/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.ejb;

import java.util.HashMap;
import org.wildfly.swarm.config.Ejb3;
import org.wildfly.swarm.config.ejb3.AsyncService;
import org.wildfly.swarm.config.ejb3.Cache;
import org.wildfly.swarm.config.ejb3.StrictMaxBeanInstancePool;
import org.wildfly.swarm.config.ejb3.ThreadPool;
import org.wildfly.swarm.config.ejb3.TimerService;
import org.wildfly.swarm.config.ejb3.service.FileDataStore;
import org.wildfly.swarm.config.security.SecurityDomain;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthorization;
import org.wildfly.swarm.config.security.security_domain.authorization.PolicyModule;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.Fraction;
import org.wildfly.swarm.security.SecurityFraction;

public class EJBFraction
extends Ejb3<EJBFraction>
implements Fraction {
    protected EJBFraction() {
    }

    public void postInitialize(Container.PostInitContext initContext) {
        SecurityDomain ejbPolicy;
        SecurityFraction security = (SecurityFraction)initContext.fraction("security");
        if (security != null && (ejbPolicy = (SecurityDomain)security.subresources().securityDomains().stream().filter(e -> e.getKey().equals("jboss-ejb-policy")).findFirst().orElse(null)) == null) {
            ejbPolicy = new SecurityDomain("jboss-ejb-policy").classicAuthorization(new ClassicAuthorization().policyModule(new PolicyModule("default").code("Delegating").flag("required")));
            security.securityDomain(ejbPolicy);
        }
        System.err.println("found security: " + security);
    }

    public static EJBFraction createDefaultFraction() {
        HashMap<String, String> threadPoolSettings = new HashMap<String, String>();
        threadPoolSettings.put("time", "100");
        threadPoolSettings.put("unit", "MILLISECONDS");
        EJBFraction fraction = new EJBFraction();
        ((EJBFraction)((EJBFraction)((EJBFraction)((EJBFraction)((EJBFraction)((EJBFraction)((EJBFraction)((EJBFraction)((EJBFraction)((EJBFraction)((EJBFraction)((EJBFraction)fraction.defaultStatefulBeanAccessTimeout(5000L)).defaultSingletonBeanAccessTimeout(5000L)).defaultSfsbCache("simple")).defaultSecurityDomain("other")).defaultMissingMethodPermissionsDenyAccess(true)).logSystemExceptions(true)).defaultResourceAdapterName("${ejb.resource-adapter-name:activemq-ra.rar}")).strictMaxBeanInstancePool(new StrictMaxBeanInstancePool("slsb-strict-max-pool").maxPoolSize(Integer.valueOf(20)).timeout(Long.valueOf(5L)).timeoutUnit("MINUTES"))).strictMaxBeanInstancePool(new StrictMaxBeanInstancePool("mdb-strict-max-pool").maxPoolSize(Integer.valueOf(20)).timeout(Long.valueOf(5L)).timeoutUnit("MINUTES"))).cache(new Cache("simple"))).asyncService(new AsyncService().threadPoolName("default"))).timerService(new TimerService().threadPoolName("default").defaultDataStore("default-file-store").fileDataStore(new FileDataStore("default-file-store").path("timer-service-data").relativeTo("jboss.server.data.dir")))).threadPool(new ThreadPool("default").maxThreads(Integer.valueOf(10)).keepaliveTime(threadPoolSettings));
        return fraction;
    }
}

