/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ModuleDescriptor;
import org.wildfly.swarm.plugin.ModuleRewriteRules;

public class ModuleRewriteConf {
    private static final String MODULE = "module:";
    private static final String OPTIONAL = "optional:";
    private Map<String, ModuleRewriteRules> rules = new HashMap<String, ModuleRewriteRules>();

    public ModuleRewriteConf(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            this.load(file);
        }
    }

    public ModuleDescriptor rewrite(ModuleDescriptor desc) {
        ModuleRewriteRules all;
        ModuleRewriteRules rules;
        String descName = desc.getName();
        String descSlot = desc.getSlot();
        if (descSlot == null) {
            descSlot = "main";
        }
        if ((rules = this.rules.get(descName + ":" + descSlot)) != null) {
            desc = rules.rewrite(desc);
        }
        if ((all = this.rules.get("ALL:ALL")) != null) {
            desc = all.rewrite(desc);
        }
        return desc;
    }

    protected void load(Path file) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(file.toFile()));){
            ModuleRewriteRules current = null;
            String line = null;
            int lineNumber = 0;
            while ((line = in.readLine()) != null) {
                String[] parts;
                String slot;
                String name;
                ++lineNumber;
                if ((line = line.trim()).isEmpty()) continue;
                if (line.startsWith(OPTIONAL)) {
                    name = null;
                    slot = "main";
                    parts = line.substring(OPTIONAL.length()).trim().split(":");
                    name = parts[0];
                    if (parts.length > 1) {
                        slot = parts[1];
                    }
                    current.makeOptional(name, slot);
                    continue;
                }
                if (line.startsWith(MODULE)) {
                    name = null;
                    slot = "main";
                    parts = line.substring(MODULE.length()).trim().split(":");
                    name = parts[0];
                    if (parts.length > 1) {
                        slot = parts[1];
                    }
                    if ((current = this.rules.get(name + ":" + slot)) != null) continue;
                    current = new ModuleRewriteRules(name, slot);
                    this.rules.put(name + ":" + slot, current);
                    continue;
                }
                System.err.println(lineNumber + ":Lines should blank, or start with " + MODULE + " or " + OPTIONAL + ": " + line);
            }
        }
    }
}

