/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.wildfly.swarm.plugin.Fraction;

@Mojo(name="fraction-list", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class FractionListMojo
extends AbstractMojo {
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Inject
    ProjectBuilder projectBuilder;
    @Component
    private MavenProject project;
    @Inject
    private ArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List dependencies = this.project.getDependencyManagement().getDependencies();
        ArrayList<Object> fractionsDependencies = new ArrayList<Object>();
        for (Object dependency : dependencies) {
            System.err.println("check: " + dependency);
            if (!this.isFraction((Dependency)dependency)) continue;
            System.err.println("+++++: " + dependency);
            fractionsDependencies.add(dependency);
        }
        HashMap<String, Fraction> fractions = new HashMap<String, Fraction>();
        for (Dependency dependency : fractionsDependencies) {
            fractions.put(dependency.getGroupId() + ":" + dependency.getArtifactId(), new Fraction(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()));
        }
        for (Dependency dependency : fractionsDependencies) {
            Fraction current = (Fraction)fractions.get(dependency.getGroupId() + ":" + dependency.getArtifactId());
            try {
                MavenProject fractionProject = this.project(dependency);
                Set deps = fractionProject.getArtifacts();
                for (org.apache.maven.artifact.Artifact each : deps) {
                    Fraction f = (Fraction)fractions.get(each.getGroupId() + ":" + each.getArtifactId());
                    if (f == null) continue;
                    current.addDependency(f);
                }
            }
            catch (ProjectBuildingException e) {
                e.printStackTrace();
            }
        }
        File outFile = new File(this.project.getBuild().getOutputDirectory(), "fraction-list.txt");
        outFile.getParentFile().mkdirs();
        try (FileWriter fileWriter = new FileWriter(outFile);){
            for (Fraction each : fractions.values()) {
                fileWriter.write(each.toString());
                fileWriter.write(" = ");
                fileWriter.write(each.getDependenciesString());
                fileWriter.write("\n");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected MavenProject project(Dependency dependency) throws ProjectBuildingException {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
        request.setProcessPlugins(false);
        request.setSystemProperties(System.getProperties());
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        request.setRepositorySession((RepositorySystemSession)this.repositorySystemSession);
        request.setResolveDependencies(true);
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "compile", "", "", (ArtifactHandler)new DefaultArtifactHandler());
        MavenProject project = this.projectBuilder.build((org.apache.maven.artifact.Artifact)artifact, (ProjectBuildingRequest)request).getProject();
        return project;
    }

    protected boolean isFraction(Dependency dep) {
        return this.isFraction(dep, false);
    }

    protected boolean isFraction(Dependency dep, boolean tryApi) {
        if (!dep.getType().equals("jar")) {
            return false;
        }
        if (!dep.getGroupId().equals("org.wildfly.swarm")) {
            return false;
        }
        ArtifactRequest req = new ArtifactRequest();
        DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId() + ":" + dep.getArtifactId() + (tryApi ? "-api" : "") + ":" + dep.getVersion());
        req.setArtifact((Artifact)artifact);
        req.setRepositories(this.project.getRemoteProjectRepositories());
        try {
            ArtifactResult artifactResult = this.resolver.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, req);
            if (artifactResult.isResolved()) {
                File file = artifactResult.getArtifact().getFile();
                JarFile jar = new JarFile(file);
                ZipEntry bootstrap = jar.getEntry("wildfly-swarm-bootstrap.conf");
                if (bootstrap != null) {
                    return true;
                }
                if (!tryApi) {
                    return this.isFraction(dep, true);
                }
                return false;
            }
        }
        catch (ArtifactResolutionException artifactResolutionException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

