/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ArtifactType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ModuleDependencyType;
import org.jboss.shrinkwrap.descriptor.api.jbossmodule13.ModuleDescriptor;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.ModuleAliasDescriptorImpl;
import org.jboss.shrinkwrap.descriptor.impl.jbossmodule13.ModuleDescriptorImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.spi.node.dom.XmlDomNodeImporterImpl;
import org.wildfly.swarm.plugin.ModuleRewriteConf;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateMojo
extends AbstractMojo {
    private static final String MODULES_PREFIX = "modules/";
    private static final String MODULES_LAYERS_PREFIX = "modules/system/layers/";
    private static final String MODULES_SUFFIX = "/module.xml";
    private static Pattern ARTIFACT_PATTERN = Pattern.compile("<artifact groupId=\"([^\"]+)\" artifactId=\"([^\"]+)\" version=\"([^\"]+)\"( classifier=\"([^\"]+)\")?.*");
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    private String projectBuildDir;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private String projectOutputDir;
    @Inject
    private ArtifactResolver resolver;
    private Map<String, ModuleDescriptor> modules = new HashMap<String, ModuleDescriptor>();
    private ModuleRewriteConf rules;
    private Set<String> allArtifacts = new HashSet<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.loadRewriteRules();
            HashSet<String> requiredModules = new HashSet<String>();
            HashSet<String> availableModules = new HashSet<String>();
            this.walkProjectModules(requiredModules, availableModules);
            this.walkDependencyModules(requiredModules, availableModules);
            HashMap<String, File> potentialModules = new HashMap<String, File>();
            this.indexPotentialModules(potentialModules);
            this.locateFillModules(potentialModules, requiredModules, availableModules);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to walk modules directory", (Throwable)e);
        }
        long size = 0L;
        DecimalFormat fmt = new DecimalFormat("####.00");
        for (String each : this.allArtifacts) {
            ArtifactRequest req = new ArtifactRequest();
            DefaultArtifact artifact = new DefaultArtifact(each);
            req.setArtifact((org.eclipse.aether.artifact.Artifact)artifact);
            try {
                ArtifactResult artifactResult = this.resolver.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, req);
                if (!artifactResult.isResolved()) continue;
                File file = artifactResult.getArtifact().getFile();
                long artifactSize = Files.size(file.toPath());
                size += artifactSize;
                this.getLog().info((CharSequence)String.format("%100s %10s mb", each, fmt.format((double)artifactSize / 1048576.0)));
            }
            catch (ArtifactResolutionException artifactResolutionException) {
            }
            catch (IOException iOException) {}
        }
        this.getLog().info((CharSequence)(this.project.getArtifactId() + ": total size:  " + fmt.format((double)size / 1048576.0) + " mb"));
    }

    protected void loadRewriteRules() throws IOException {
        Path rewriteConf = Paths.get(this.project.getBasedir().getAbsolutePath(), "module-rewrite.conf");
        this.rules = new ModuleRewriteConf(rewriteConf);
    }

    protected void locateFillModules(Map<String, File> potentialModules, Set<String> requiredModules, Set<String> availableModules) throws IOException, MojoFailureException {
        boolean counter = true;
        while (true) {
            HashSet<String> fillModules = new HashSet<String>();
            fillModules.addAll(requiredModules);
            fillModules.removeAll(availableModules);
            if (fillModules.isEmpty()) break;
            HashSet<File> relevantFiles = new HashSet<File>();
            for (String each : fillModules) {
                File file = potentialModules.get(each);
                if (file == null) {
                    throw new MojoFailureException("Unable to locate required module: " + each);
                }
                relevantFiles.add(file);
            }
            this.addFillModules(fillModules, relevantFiles, requiredModules, availableModules);
        }
    }

    protected void addFillModules(Set<String> fillModules, Set<File> relevantFiles, Set<String> requiredModules, Set<String> availableModules) throws IOException, MojoFailureException {
        for (File each : relevantFiles) {
            this.addFillModules(fillModules, each, requiredModules, availableModules);
        }
    }

    protected void addFillModules(Set<String> fillModules, File file, Set<String> requiredModules, Set<String> availableModules) throws IOException, MojoFailureException {
        HashMap<String, ZipEntry> moduleXmls = new HashMap<String, ZipEntry>();
        ZipEntry featurePackXml = null;
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                String coreName = null;
                if (name.equals("wildfly-feature-pack.xml")) {
                    featurePackXml = entry;
                } else if (name.startsWith(MODULES_LAYERS_PREFIX) && name.endsWith(MODULES_SUFFIX)) {
                    coreName = name.substring(MODULES_LAYERS_PREFIX.length(), name.length() - MODULES_SUFFIX.length());
                    coreName = coreName.substring(coreName.indexOf(47) + 1);
                } else if (name.startsWith(MODULES_PREFIX) && name.endsWith(MODULES_SUFFIX)) {
                    coreName = name.substring(MODULES_PREFIX.length(), name.length() - MODULES_SUFFIX.length());
                }
                if (coreName == null) continue;
                int lastSlashLoc = coreName.lastIndexOf(47);
                String moduleName = coreName.substring(0, lastSlashLoc);
                String slot = coreName.substring(lastSlashLoc + 1);
                if (!fillModules.contains((moduleName = moduleName.replace('/', '.')) + ":" + slot)) continue;
                moduleXmls.put(moduleName + ":" + slot, entry);
            }
            if (featurePackXml == null) {
                throw new MojoFailureException("Unable to find -feature-pack.xml");
            }
            Map<String, String> versions = this.processFeaturePackXml(zip.getInputStream(featurePackXml));
            for (String moduleName : moduleXmls.keySet()) {
                ZipEntry entry = (ZipEntry)moduleXmls.get(moduleName);
                this.addFillModule(versions, moduleName, zip.getInputStream(entry), requiredModules, availableModules);
                this.addResources(zip, moduleName, entry);
            }
        }
    }

    protected void addResources(ZipFile zip, String moduleName, ZipEntry moduleXml) {
        String moduleXmlPath = moduleXml.getName();
        String rootName = moduleXmlPath.substring(0, moduleXmlPath.length() - "module.xml".length());
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().startsWith(rootName) || entry.getName().equals(moduleXmlPath)) continue;
            String resourceRelative = entry.getName().substring(rootName.length());
            resourceRelative.replace('/', File.separatorChar);
            Path classesDir = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
            Path modulesDir = classesDir.resolve("modules");
            String[] parts = moduleName.split(":");
            String[] moduleParts = parts[0].split("\\.");
            Path moduleDir = modulesDir;
            for (int i = 0; i < moduleParts.length; ++i) {
                moduleDir = moduleDir.resolve(moduleParts[i]);
            }
            moduleDir = moduleDir.resolve(parts[1]);
            Path resourcePath = moduleDir.resolve(resourceRelative);
            try {
                Files.createDirectories(resourcePath.getParent(), new FileAttribute[0]);
                Files.copy(zip.getInputStream(entry), resourcePath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void addFillModule(Map<String, String> versions, String moduleName, InputStream in, Set<String> requiredModules, Set<String> availableModules) throws IOException {
        Path classesDir = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
        Path modulesDir = classesDir.resolve("modules");
        String[] parts = moduleName.split(":");
        String[] moduleParts = parts[0].split("\\.");
        Path moduleDir = modulesDir;
        for (int i = 0; i < moduleParts.length; ++i) {
            moduleDir = moduleDir.resolve(moduleParts[i]);
        }
        moduleDir = moduleDir.resolve(parts[1]);
        Path moduleXml = moduleDir.resolve("module.xml");
        this.processFillModule(versions, moduleXml, in);
        this.analyzeModuleXml(modulesDir, moduleXml, requiredModules, availableModules);
    }

    protected void processFillModule(Map<String, String> versions, Path moduleXml, InputStream in) throws IOException {
        Files.createDirectories(moduleXml.getParent(), new FileAttribute[0]);
        XmlDomNodeImporterImpl importer = new XmlDomNodeImporterImpl();
        Node node = importer.importAsNode(in, true);
        String rootName = node.getName();
        if (rootName.equals("module")) {
            ModuleDescriptorImpl desc = new ModuleDescriptorImpl(null, node);
            List artifacts = desc.getOrCreateResources().getAllArtifact();
            for (ArtifactType artifact : artifacts) {
                String name = artifact.getName();
                if (name.startsWith("${")) {
                    name = name.substring(2, name.length() - 1);
                }
                if (name.endsWith("?jandex")) {
                    name = name.replace("?jandex", "");
                }
                name = versions.get(name);
                artifact.name(name);
                this.allArtifacts.add(name);
            }
            desc = this.rules.rewrite((ModuleDescriptor)desc);
            try (FileOutputStream out = new FileOutputStream(moduleXml.toFile());){
                desc.exportTo((OutputStream)out);
            }
        }
        if (rootName.equals("module-alias")) {
            ModuleAliasDescriptorImpl desc = new ModuleAliasDescriptorImpl(null, node);
            try (FileOutputStream out = new FileOutputStream(moduleXml.toFile());){
                desc.exportTo((OutputStream)out);
            }
        }
    }

    protected Map<String, String> processFeaturePackXml(InputStream in) throws IOException {
        HashMap<String, String> versions = new HashMap<String, String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = ARTIFACT_PATTERN.matcher(line = line.trim());
                if (!matcher.matches()) continue;
                MatchResult result = matcher.toMatchResult();
                String groupId = result.group(1);
                String artifactId = result.group(2);
                String version = result.group(3);
                String classifier = result.group(5);
                String expr = groupId + ":" + artifactId + (classifier == null ? "" : "::" + classifier);
                String qualified = groupId + ":" + artifactId + ":" + version + (classifier == null ? "" : ":" + classifier);
                versions.put(expr, qualified);
            }
        }
        return versions;
    }

    protected void indexPotentialModules(Map<String, File> potentialModules) throws IOException {
        Set artifacts = this.project.getArtifacts();
        for (Artifact each : artifacts) {
            if (!each.getType().equals("zip")) continue;
            this.indexPotentialModules(each.getFile(), potentialModules);
        }
    }

    protected void indexPotentialModules(File file, Map<String, File> potentialModules) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry each = entries.nextElement();
                String name = each.getName();
                String coreName = null;
                if (name.startsWith(MODULES_LAYERS_PREFIX) && name.endsWith(MODULES_SUFFIX)) {
                    coreName = name.substring(MODULES_LAYERS_PREFIX.length(), name.length() - MODULES_SUFFIX.length());
                    coreName = coreName.substring(coreName.indexOf(47) + 1);
                } else if (name.startsWith(MODULES_PREFIX) && name.endsWith(MODULES_SUFFIX)) {
                    coreName = name.substring(MODULES_PREFIX.length(), name.length() - MODULES_SUFFIX.length());
                }
                if (coreName == null) continue;
                int lastSlashLoc = coreName.lastIndexOf(47);
                String moduleName = coreName.substring(0, lastSlashLoc);
                String slot = coreName.substring(lastSlashLoc + 1);
                moduleName = moduleName.replace('/', '.');
                potentialModules.put(moduleName + ":" + slot, file);
            }
        }
    }

    protected void walkProjectModules(final Set<String> requiredModules, final Set<String> availableModules) throws IOException {
        List resources = this.project.getBuild().getResources();
        for (Resource each : resources) {
            final Path modulesDir = Paths.get(each.getDirectory(), new String[0]).resolve("modules");
            if (!Files.exists(modulesDir, new LinkOption[0])) continue;
            Files.walkFileTree(modulesDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().equals("module.xml")) {
                        GenerateMojo.this.analyzeModuleXml(modulesDir, file, requiredModules, availableModules);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    protected void walkDependencyModules(Set<String> requiredModules, Set<String> availableModules) throws IOException {
        Set artifacts = this.project.getArtifacts();
        for (Artifact each : artifacts) {
            this.collectAvailableModules(each, availableModules);
        }
    }

    protected void collectAvailableModules(Artifact artifact, Set<String> modules) throws IOException {
        if (artifact.getType().equals("jar")) {
            try (JarFile jar = new JarFile(artifact.getFile());){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry each = entries.nextElement();
                    String name = each.getName();
                    if (!name.startsWith(MODULES_PREFIX) || !name.endsWith(MODULES_SUFFIX)) continue;
                    String coreName = name.substring(MODULES_PREFIX.length(), name.length() - MODULES_SUFFIX.length());
                    int lastSlashLoc = coreName.lastIndexOf(47);
                    String moduleName = coreName.substring(0, lastSlashLoc);
                    String slot = coreName.substring(lastSlashLoc + 1);
                    moduleName = moduleName.replace('/', '.');
                    modules.add(moduleName + ":" + slot);
                }
            }
        }
    }

    protected void analyzeModuleXml(Path root, Path moduleXml, Set<String> requiredModules, Set<String> availableModules) throws IOException {
        Path modulePath = root.relativize(moduleXml).getParent();
        String selfSlot = modulePath.getName(modulePath.getNameCount() - 1).toString();
        String selfModuleName = modulePath.getParent().toString().replace(File.separatorChar, '.');
        this.getLog().info((CharSequence)("Analyzing: " + selfModuleName + ":" + selfSlot + " (" + moduleXml + ")"));
        availableModules.add(selfModuleName + ":" + selfSlot);
        XmlDomNodeImporterImpl importer = new XmlDomNodeImporterImpl();
        Node node = importer.importAsNode((InputStream)new FileInputStream(moduleXml.toFile()), true);
        String rootName = node.getName();
        if (rootName.equals("module")) {
            ModuleDescriptorImpl desc = new ModuleDescriptorImpl(null, node);
            desc = this.rules.rewrite((ModuleDescriptor)desc);
            DependenciesType dependencies = desc.getOrCreateDependencies();
            List moduleDependencies = dependencies.getAllModule();
            for (ModuleDependencyType moduleDependency : moduleDependencies) {
                if (moduleDependency.isOptional().booleanValue()) continue;
                String name = moduleDependency.getName();
                String slot = moduleDependency.getSlot();
                if (slot == null) {
                    slot = "main";
                }
                requiredModules.add(name + ":" + slot);
                this.getLog().info((CharSequence)(" - requires: " + name + ":" + slot));
            }
        } else if (rootName.equals("module-alias")) {
            ModuleAliasDescriptorImpl desc = new ModuleAliasDescriptorImpl(null, node);
            String name = desc.getTargetName();
            String slot = desc.getTargetSlot();
            if (slot == null) {
                slot = "main";
            }
            requiredModules.add(name + ":" + slot);
            this.getLog().info((CharSequence)(" - requires: " + name + ":" + slot));
        }
    }
}

