/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class Fraction {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Set<Fraction> dependencies = new HashSet<Fraction>();

    public Fraction(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void addDependency(Fraction fraction) {
        this.dependencies.add(fraction);
    }

    public Set<Fraction> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        String artifactId = this.artifactId;
        if (artifactId.endsWith("-api")) {
            artifactId = artifactId.substring(0, artifactId.length() - 4);
        }
        return this.groupId + ":" + artifactId + ":" + this.version;
    }

    public String getDependenciesString() {
        return String.join((CharSequence)", ", this.dependencies.stream().map(e -> e.toString()).collect(Collectors.toList()));
    }
}

