/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class BootstrapMarker {
    public static final String BOOTSTRAP_MARKER = "wildfly-swarm-bootstrap.conf";
    private final Log log;
    private final MavenProject project;
    private Path fraction;
    private boolean bootstrapMarkerFound;

    public BootstrapMarker(Log log, MavenProject project) {
        this.log = log;
        this.project = project;
    }

    public void execute() throws IOException {
        Path src = Paths.get(this.project.getBuild().getSourceDirectory(), new String[0]);
        if (!Files.exists(src, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(src, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().endsWith("Fraction.java")) {
                    BootstrapMarker.this.fraction = file;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        for (Resource dir : this.project.getBuild().getResources()) {
            Path dirPath = Paths.get(dir.getDirectory(), new String[0]);
            if (!Files.exists(dirPath, new LinkOption[0]) || !Files.isDirectory(dirPath, new LinkOption[0])) continue;
            Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().equals(BootstrapMarker.BOOTSTRAP_MARKER)) {
                        BootstrapMarker.this.bootstrapMarkerFound = true;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        if (!this.bootstrapMarkerFound && this.fraction != null) {
            this.createBootstrapMarker();
        }
    }

    private void createBootstrapMarker() throws IOException {
        Path path = Paths.get(this.project.getBuild().getSourceDirectory(), new String[0]).relativize(this.fraction).getParent();
        String moduleName = path.toString().replaceAll(File.separator, ".");
        try (FileWriter writer = new FileWriter(new File(this.project.getBuild().getOutputDirectory(), BOOTSTRAP_MARKER));){
            writer.write(moduleName);
            writer.write("\n");
            writer.flush();
        }
    }
}

