/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.wildfly.swarm.plugin.ExposedComponent;

public abstract class AbstractExposedComponentsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(alias="remoteRepositories", defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Inject
    private ArtifactResolver resolver;
    @Parameter
    private List<String> modules = new ArrayList<String>();

    protected static Proxy convertFromMavenProxy(org.apache.maven.settings.Proxy proxy) {
        if (proxy != null) {
            return new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build());
        }
        return null;
    }

    protected File resolveArtifact(String group, String name, String version, String classifier, String type) throws ArtifactResolutionRuntimeException {
        List aetherRepos = this.remoteRepositories.stream().map(r -> this.buildRemoteRepository(r.getId(), r.getUrl(), r.getAuthentication())).collect(Collectors.toList());
        DefaultArtifact artifact = new DefaultArtifact(group, name, classifier, type, version);
        LocalArtifactResult localResult = this.repositorySystemSession.getLocalRepositoryManager().find((RepositorySystemSession)this.repositorySystemSession, new LocalArtifactRequest((Artifact)artifact, aetherRepos, null));
        File file = null;
        if (localResult.isAvailable()) {
            file = localResult.getFile();
        } else {
            ArtifactResult result;
            try {
                result = this.resolver.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, new ArtifactRequest((Artifact)artifact, aetherRepos, null));
            }
            catch (ArtifactResolutionException e) {
                throw new ArtifactResolutionRuntimeException(e);
            }
            if (result.isResolved()) {
                file = result.getArtifact().getFile();
            }
        }
        return file;
    }

    protected RemoteRepository buildRemoteRepository(String id, String url, Authentication auth) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, "default", url);
        if (auth != null && auth.getUsername() != null && auth.getPassword() != null) {
            builder.setAuthentication(new AuthenticationBuilder().addUsername(auth.getUsername()).addPassword(auth.getPassword()).build());
        }
        builder.setProxy(AbstractExposedComponentsMojo.convertFromMavenProxy(this.mavenSession.getSettings().getActiveProxy()));
        return builder.build();
    }

    protected Map<String, String> parseModules() {
        HashMap<String, String> versions = new HashMap<String, String>();
        this.modules.forEach(c -> {
            String[] parts = c.split(":");
            versions.put(parts[0], parts[1]);
        });
        return versions;
    }

    protected Map<String, List<ExposedComponent>> resolveComponents(Map<String, String> versions) {
        HashMap<String, List<ExposedComponent>> componentMap = new HashMap<String, List<ExposedComponent>>();
        versions.forEach((k, v) -> componentMap.put((String)k, this.resolveComponentDescriptor((String)k, (String)v)));
        return componentMap;
    }

    protected List<ExposedComponent> resolveComponentDescriptor(String name, String version) {
        File descriptorFile = null;
        try {
            descriptorFile = this.resolveArtifact("org.wildfly.swarm", name, version, "exposed-components", "json");
        }
        catch (ArtifactResolutionRuntimeException e) {
            throw new RuntimeException(String.format("Failed to locate exposed-components.json for %s:%s", name, version), e.getCause());
        }
        try {
            return descriptorFile != null ? ExposedComponent.parseDescriptor(descriptorFile.toURI().toURL()) : null;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Failed to read exposed-components.json for %s:%s", name, version), e);
        }
    }

    static class ArtifactResolutionRuntimeException
    extends RuntimeException {
        public ArtifactResolutionRuntimeException(ArtifactResolutionException cause) {
            super((Throwable)cause);
        }
    }
}

