/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wildfly.swarm.plugin.ExposedComponent;

public class BomBuilder {
    public static final String SWARM_GROUP = "org.wildfly.swarm";
    private static final String DEP_TEMPLATE = "      <dependency>\n        <groupId>%s</groupId>\n        <artifactId>%s</artifactId>\n        <version>%s</version>\n      </dependency>";

    public static String generateBOM(String template, Map<String, String> versions, Map<String, List<ExposedComponent>> components) {
        return template.replace("#{dependencies}", String.join((CharSequence)"\n", BomBuilder.dependenciesList(versions, components).stream().map(BomBuilder::pomGav).collect(Collectors.toList())));
    }

    public static List<String> dependenciesList(Map<String, String> versions, Map<String, List<ExposedComponent>> components) {
        return versions.keySet().stream().flatMap(module -> ((List)components.get(module)).stream().filter(d -> d.bom).map(d -> BomBuilder.gav(d.name, (String)versions.get(module)))).collect(Collectors.toList());
    }

    private static String gav(String name, String version) {
        return String.format("%s:%s:%s", SWARM_GROUP, name, version);
    }

    private static String pomGav(String gav) {
        String[] parts = gav.split(":");
        return String.format(DEP_TEMPLATE, parts[0], parts[1], parts[2]);
    }
}

