/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.wildfly.swarm.plugin.AbstractExposedComponentsMojo;
import org.wildfly.swarm.plugin.BomBuilder;
import org.wildfly.swarm.plugin.ExposedComponent;

@Mojo(name="generate-bom", defaultPhase=LifecyclePhase.PACKAGE)
public class BomMojo
extends AbstractExposedComponentsMojo {
    @Parameter
    private File template;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<String, String> versions = this.parseModules();
        Map<String, List<ExposedComponent>> componentMap = this.resolveComponents(versions);
        this.verifyBomDependencies(BomBuilder.dependenciesList(versions, componentMap));
        Path bomPath = Paths.get(this.project.getBuild().getOutputDirectory(), "bom.pom");
        try {
            Files.write(bomPath, BomBuilder.generateBOM(this.readTemplate(), versions, componentMap).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to write bom.pom", (Throwable)e);
        }
        this.getLog().info((CharSequence)String.format("Wrote bom to %s", bomPath));
    }

    protected void verifyBomDependencies(List<String> deps) throws MojoFailureException {
        for (String dep : deps) {
            String[] parts = dep.split(":");
            try {
                this.resolveArtifact(parts[0], parts[1], parts[2], null, "pom");
            }
            catch (AbstractExposedComponentsMojo.ArtifactResolutionRuntimeException e) {
                throw new MojoFailureException(String.format("%s does not resolvable", dep), e.getCause());
            }
        }
    }

    protected String readTemplate() throws MojoFailureException {
        if (this.template == null) {
            throw new MojoFailureException("No template specified");
        }
        try {
            return new String(Files.readAllBytes(this.template.toPath()), "UTF-8");
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to read template " + this.template, (Throwable)e);
        }
    }
}

