/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.swarm.plugin.AbstractExposedComponentsMojo;
import org.wildfly.swarm.plugin.ExposedComponent;

@Mojo(name="prep-doc-source", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class DocPrepMojo
extends AbstractExposedComponentsMojo {
    @Parameter
    private File sourceOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List sourceArtifacts;
        Map<String, String> versions = this.parseModules();
        Map<String, List<ExposedComponent>> components = this.resolveComponents(versions);
        try {
            sourceArtifacts = versions.keySet().stream().flatMap(module -> ((List)components.get(module)).stream().filter(d -> d.doc != null).map(d -> this.resolveArtifact("org.wildfly.swarm", d.doc, (String)versions.get(module), "sources", "jar"))).collect(Collectors.toList());
        }
        catch (AbstractExposedComponentsMojo.ArtifactResolutionRuntimeException e) {
            throw new MojoFailureException("Failed to resolve sources artifact", e.getCause());
        }
        this.sourceOutputDir.mkdirs();
        for (File each : sourceArtifacts) {
            ((ExplodedExporter)((JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)each)).as(ExplodedExporter.class)).exportExploded(this.sourceOutputDir, ".");
        }
    }
}

