/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.wildfly.swarm.plugin.Fraction;

@Mojo(name="fraction-list", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class FractionListMojo
extends AbstractMojo {
    private static final String GENERATOR_CATEGORY_PROPERTY = "swarm.generator.category";
    private static final String DEFAULT_GENERATOR_CATEGORY = "";
    @Component
    protected RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Inject
    ProjectBuilder projectBuilder;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Inject
    private ArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List dependencies = this.project.getDependencyManagement().getDependencies();
        ArrayList<Dependency> fractionsDependencies = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies) {
            if (!this.isFraction(dependency)) continue;
            fractionsDependencies.add(dependency);
        }
        TreeMap<String, Fraction> fractions = new TreeMap<String, Fraction>();
        for (Dependency dependency : fractionsDependencies) {
            fractions.put(dependency.getGroupId() + ":" + dependency.getArtifactId(), new Fraction(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()));
        }
        for (Dependency dependency : fractionsDependencies) {
            Fraction current = (Fraction)fractions.get(dependency.getGroupId() + ":" + dependency.getArtifactId());
            try {
                MavenProject fractionProject = this.project(dependency);
                current.setName(fractionProject.getName());
                current.setDescription(fractionProject.getDescription());
                current.setCategory(fractionProject.getProperties().getProperty(GENERATOR_CATEGORY_PROPERTY, DEFAULT_GENERATOR_CATEGORY));
                Set deps = fractionProject.getArtifacts();
                for (org.apache.maven.artifact.Artifact each : deps) {
                    Fraction f = (Fraction)fractions.get(each.getGroupId() + ":" + each.getArtifactId());
                    if (f == null) continue;
                    current.addDependency(f);
                }
            }
            catch (ProjectBuildingException e) {
                e.printStackTrace();
            }
        }
        this.generateTxt(fractions);
        this.generateJSON(fractions);
        this.generateJavascript(fractions);
    }

    protected void generateTxt(Map<String, Fraction> fractions) {
        File outFile = new File(this.project.getBuild().getOutputDirectory(), "fraction-list.txt");
        outFile.getParentFile().mkdirs();
        try (FileWriter out = new FileWriter(outFile);){
            for (Fraction each : fractions.values()) {
                out.write(each.toString());
                out.write(" = ");
                out.write(each.getDependenciesString());
                out.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "txt", DEFAULT_GENERATOR_CATEGORY, (ArtifactHandler)new DefaultArtifactHandler("txt"));
        artifact.setFile(outFile);
        this.project.addAttachedArtifact((org.apache.maven.artifact.Artifact)artifact);
    }

    protected void generateJSON(Map<String, Fraction> fractions) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        File outFile = new File(this.project.getBuild().getOutputDirectory(), "fraction-list.json");
        try {
            mapper.writeValue(outFile, fractions.values());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "json", DEFAULT_GENERATOR_CATEGORY, (ArtifactHandler)new DefaultArtifactHandler("json"));
        artifact.setFile(outFile);
        this.project.addAttachedArtifact((org.apache.maven.artifact.Artifact)artifact);
    }

    protected void generateJavascript(Map<String, Fraction> fractions) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        File outFile = new File(this.project.getBuild().getOutputDirectory(), "fraction-list.js");
        try (FileWriter writer = new FileWriter(outFile);){
            writer.write("fractionList = ");
            writer.flush();
            mapper.writeValue((Writer)writer, fractions.values());
            writer.write(";");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "compile", "js", DEFAULT_GENERATOR_CATEGORY, (ArtifactHandler)new DefaultArtifactHandler("js"));
        artifact.setFile(outFile);
        this.project.addAttachedArtifact((org.apache.maven.artifact.Artifact)artifact);
    }

    protected MavenProject project(Dependency dependency) throws ProjectBuildingException {
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest();
        request.setProcessPlugins(false);
        request.setSystemProperties(System.getProperties());
        request.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        request.setRepositorySession((RepositorySystemSession)this.repositorySystemSession);
        request.setResolveDependencies(true);
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), "compile", DEFAULT_GENERATOR_CATEGORY, DEFAULT_GENERATOR_CATEGORY, (ArtifactHandler)new DefaultArtifactHandler());
        MavenProject project = this.projectBuilder.build((org.apache.maven.artifact.Artifact)artifact, (ProjectBuildingRequest)request).getProject();
        return project;
    }

    protected boolean isFraction(Dependency dep) {
        return this.isFraction(dep, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isFraction(Dependency dep, boolean tryApi) {
        if (!dep.getType().equals("jar")) {
            return false;
        }
        if (!dep.getGroupId().equals("org.wildfly.swarm")) {
            return false;
        }
        ArtifactRequest req = new ArtifactRequest();
        DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId() + ":" + dep.getArtifactId() + (tryApi ? "-api" : DEFAULT_GENERATOR_CATEGORY) + ":" + dep.getVersion());
        req.setArtifact((Artifact)artifact);
        req.setRepositories(this.project.getRemoteProjectRepositories());
        try {
            ArtifactResult artifactResult = this.resolver.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, req);
            if (!artifactResult.isResolved()) return false;
            File file = artifactResult.getArtifact().getFile();
            try (JarFile jar = new JarFile(file);){
                ZipEntry bootstrap = jar.getEntry("wildfly-swarm-bootstrap.conf");
                if (bootstrap != null) {
                    boolean bl = true;
                    return bl;
                }
            }
            if (tryApi) return false;
            return this.isFraction(dep, true);
        }
        catch (ArtifactResolutionException artifactResolutionException) {
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

