/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.wildfly.swarm.fractions.PropertiesUtil;
import org.wildfly.swarm.plugin.gradle.GradleArtifactResolvingHelper;
import org.wildfly.swarm.plugin.gradle.SwarmExtension;
import org.wildfly.swarm.spi.meta.SimpleLogger;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.DeclaredDependencies;

public class PackageTask
extends DefaultTask {
    private static final String MODULE_DIR_NAME = "modules";
    private BuildTool tool;
    private Jar jarTask;

    public Task jarTask(Jar jarTask) {
        this.jarTask = jarTask;
        return this;
    }

    @TaskAction
    public void packageForSwarm() throws Exception {
        Path resourcesOutputDir;
        Project project = this.getProject();
        GradleArtifactResolvingHelper resolvingHelper = new GradleArtifactResolvingHelper(project);
        Properties propertiesFromExtension = this.getPropertiesFromExtension();
        List<File> moduleDirs = this.getModuleDirs();
        if (moduleDirs.isEmpty() && Files.isDirectory(resourcesOutputDir = ((SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().findByName("main")).getOutput().getResourcesDir().toPath().resolve(MODULE_DIR_NAME), new LinkOption[0])) {
            File moduleDir = resourcesOutputDir.toFile();
            moduleDirs.add(moduleDir);
        }
        this.tool = new BuildTool((ArtifactResolvingHelper)resolvingHelper).projectArtifact(this.jarTask.getGroup().toString(), this.jarTask.getBaseName(), this.jarTask.getVersion(), this.getPackaging(), this.getProjectArtifactFile()).mainClass(this.getMainClassName()).bundleDependencies(this.getBundleDependencies().booleanValue()).executable(this.getExecutable()).executableScript(this.getExecutableScript()).properties(propertiesFromExtension).properties(this.getPropertiesFromFile()).properties(PropertiesUtil.filteredSystemProperties((Properties)propertiesFromExtension, (boolean)false)).fractionDetectionMode(this.getSwarmExtension().getFractionDetectMode()).hollow(this.getHollow().booleanValue()).additionalModules((Collection)moduleDirs.stream().filter(File::exists).map(File::getAbsolutePath).collect(Collectors.toList())).logger(new SimpleLogger(){

            public void debug(String msg) {
                PackageTask.this.getLogger().debug(msg);
            }

            public void info(String msg) {
                PackageTask.this.getLogger().info(msg);
            }

            public void error(String msg) {
                PackageTask.this.getLogger().error(msg);
            }

            public void error(String msg, Throwable t) {
                PackageTask.this.getLogger().error(msg, t);
            }
        });
        DeclaredDependencies declaredDependencies = new DeclaredDependencies();
        ArrayList explicitDependencies = new ArrayList();
        ResolvedConfiguration resolvedConfiguration = project.getConfigurations().getByName("default").getResolvedConfiguration();
        Set directDeps = resolvedConfiguration.getFirstLevelModuleDependencies();
        for (ResolvedDependency directDep : directDeps) {
            assert (directDep.getModuleArtifacts().iterator().hasNext()) : "Expected module artifacts";
            ArtifactSpec parent = new ArtifactSpec("compile", directDep.getModule().getId().getGroup(), directDep.getModule().getId().getName(), directDep.getModule().getId().getVersion(), ((ResolvedArtifact)directDep.getModuleArtifacts().iterator().next()).getExtension(), null, null);
            Set artifactSpecs = resolvingHelper.resolveAll(new HashSet<ArtifactSpec>(Collections.singletonList(parent)));
            artifactSpecs.forEach(a -> declaredDependencies.add((Object)parent, a));
        }
        this.tool.declaredDependencies(declaredDependencies);
        Boolean bundleDependencies = this.getBundleDependencies();
        if (bundleDependencies != null) {
            this.tool.bundleDependencies(bundleDependencies.booleanValue());
        }
        this.tool.build(this.getOutputFile().getName(), this.getOutputDirectory());
        java.util.Optional<Task> task = project.getTasks().stream().filter(t -> "war".equals(t.getName())).findAny();
        if (task.isPresent()) {
            Set warArchives = project.getConfigurations().stream().map(Configuration::getAllArtifacts).map(PublishArtifactSet::getFiles).map(FileCollection::getFiles).flatMap(Collection::stream).filter(f -> f.getName().endsWith(".war")).collect(Collectors.toSet());
            for (File warArchive : warArchives) {
                this.tool.repackageWar(warArchive);
            }
        }
    }

    @Input
    private String getPackaging() {
        return this.jarTask.getExtension();
    }

    @InputFile
    private File getProjectArtifactFile() {
        return this.jarTask.getArchivePath();
    }

    @Input
    @Optional
    private String getMainClassName() {
        Project project = this.getProject();
        SwarmExtension swarmExtension = this.getSwarmExtension();
        String mainClassName = swarmExtension.getMainClassName();
        if (mainClassName == null && project.getConvention().getPlugins().containsKey("application")) {
            ApplicationPluginConvention app = (ApplicationPluginConvention)project.getConvention().getPlugins().get("application");
            mainClassName = app.getMainClassName();
        }
        if (mainClassName != null && !mainClassName.equals("")) {
            this.getLogger().warn("\n------\nCustom main() usage is intended to be deprecated in a future release and is no longer supported, \nplease refer to http://docs.wildfly-swarm.io for YAML configuration that replaces it.\n------");
        }
        return mainClassName;
    }

    private SwarmExtension getSwarmExtension() {
        return (SwarmExtension)this.getProject().getExtensions().getByType(SwarmExtension.class);
    }

    @Input
    @Optional
    private Boolean getBundleDependencies() {
        return this.getSwarmExtension().getBundleDependencies();
    }

    @Input
    @Optional
    private Boolean getHollow() {
        return this.getSwarmExtension().getHollow();
    }

    @Input
    private boolean getExecutable() {
        return this.getSwarmExtension().getExecutable();
    }

    @Optional
    @InputFile
    private File getExecutableScript() {
        return this.getSwarmExtension().getExecutableScript();
    }

    @Input
    private Properties getPropertiesFromExtension() {
        return this.getSwarmExtension().getProperties();
    }

    @Input
    private Properties getPropertiesFromFile() {
        Properties properties = new Properties();
        File propertiesFile = this.getPropertiesFile();
        if (propertiesFile != null) {
            try {
                properties.putAll((Map<?, ?>)PropertiesUtil.loadProperties((File)propertiesFile));
            }
            catch (IOException e) {
                this.getLogger().error("Failed to load properties from " + propertiesFile, (Throwable)e);
            }
        }
        return properties;
    }

    @Optional
    @InputFile
    private File getPropertiesFile() {
        return this.getSwarmExtension().getPropertiesFile();
    }

    @InputFiles
    private List<File> getModuleDirs() {
        return this.getSwarmExtension().getModuleDirs();
    }

    @OutputFile
    private File getOutputFile() {
        return BuildTool.getOutputFile((String)(this.getBaseName() + "-swarm.jar"), (Path)this.getOutputDirectory());
    }

    private String getBaseName() {
        return this.getProject().getName() + (this.getHollow() != false ? "-hollow" : "");
    }

    private Path getOutputDirectory() {
        return this.getProject().getBuildDir().toPath().resolve("libs");
    }
}

