/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jaxrs;

import java.io.IOException;
import javax.ws.rs.core.Application;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.container.Deployment;
import org.wildfly.swarm.jaxrs.DefaultApplication;
import org.wildfly.swarm.shrinkwrap.ShrinkWrapDeployment;

public class JaxRsDeployment
implements Deployment {
    private final ShrinkWrapDeployment<WebArchive> delegate = new ShrinkWrapDeployment(JaxRsDeployment.archiveName(), WebArchive.class);
    private Class<? extends Application> application;

    public JaxRsDeployment setApplication(Class<? extends Application> application) {
        this.application = application;
        return this;
    }

    public JaxRsDeployment addResource(Class resource) {
        return this.addClass(resource);
    }

    public JaxRsDeployment addClass(Class cls) {
        ((WebArchive)this.delegate.getArchive()).addClass(cls);
        return this;
    }

    public String getName() {
        return JaxRsDeployment.archiveName();
    }

    public VirtualFile getContent() throws IOException {
        this.ensureApplication();
        this.addWebXml();
        this.addJBossDeploymentStructure();
        return this.delegate.getContent();
    }

    private void ensureApplication() {
        if (this.application != null) {
            ((WebArchive)this.delegate.getArchive()).addClass(this.application);
        } else {
            ((WebArchive)this.delegate.getArchive()).addClass(DefaultApplication.class);
        }
    }

    private void addWebXml() {
        StringAsset webXml = new StringAsset("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\n<web-app version=\"3.0\" xmlns=\"http://java.sun.com/xml/ns/javaee\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd\">\n</web-app>\n");
        ((WebArchive)this.delegate.getArchive()).addAsWebInfResource((Asset)webXml, "web.xml");
    }

    private void addJBossDeploymentStructure() {
        StringAsset structureXml = new StringAsset("<?xml version=\"1.0\" encoding=\"UTF-8\"?>  \n<jboss-deployment-structure>  \n    <deployment>  \n         <dependencies>  \n              <module name=\"APP\" slot=\"dependencies\" />  \n        </dependencies>  \n    </deployment>  \n</jboss-deployment-structure>\n");
        ((WebArchive)this.delegate.getArchive()).addAsWebInfResource((Asset)structureXml, "jboss-deployment-structure.xml");
    }

    private static String archiveName() {
        return System.getProperty("wildfly.swarm.app.name").replace(".jar", ".war");
    }
}

