/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.jaxrs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveEvent;
import org.jboss.shrinkwrap.api.ArchiveEventHandler;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.impl.base.container.WebContainerBase;
import org.jboss.shrinkwrap.impl.base.spec.WebArchiveImpl;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.wildfly.swarm.jaxrs.AnnotationSeekingClassVisitor;
import org.wildfly.swarm.jaxrs.ApplicationFactory2;
import org.wildfly.swarm.jaxrs.FaviconExceptionMapperFactory;
import org.wildfly.swarm.jaxrs.FaviconHandler;
import org.wildfly.swarm.jaxrs.JAXRSArchive;

public class JAXRSArchiveImpl
extends WebContainerBase<JAXRSArchive>
implements JAXRSArchive {
    private static final Logger log = Logger.getLogger(WebArchiveImpl.class.getName());
    private static final ArchivePath PATH_WEB = ArchivePaths.root();
    private static final ArchivePath PATH_WEB_INF = ArchivePaths.create((String)"WEB-INF");
    private static final ArchivePath PATH_RESOURCE = ArchivePaths.create((ArchivePath)PATH_WEB_INF, (String)"classes");
    private static final ArchivePath PATH_LIBRARY = ArchivePaths.create((ArchivePath)PATH_WEB_INF, (String)"lib");
    private static final ArchivePath PATH_CLASSES = ArchivePaths.create((ArchivePath)PATH_WEB_INF, (String)"classes");
    private static final ArchivePath PATH_MANIFEST = ArchivePaths.create((String)"META-INF");
    private static final ArchivePath PATH_SERVICE_PROVIDERS = ArchivePaths.create((ArchivePath)PATH_CLASSES, (String)"META-INF/services");

    public JAXRSArchiveImpl(Archive<?> delegate) {
        super(JAXRSArchive.class, delegate);
        this.setDefaultContextRoot();
        this.addGeneratedApplication();
        this.addExceptionMapperForFavicon();
    }

    protected void addGeneratedApplication() {
        Map content = this.getArchive().getContent();
        boolean applicationFound = false;
        for (Map.Entry entry : content.entrySet()) {
            Node node = (Node)entry.getValue();
            Asset asset = node.getAsset();
            if (!JAXRSArchiveImpl.hasApplicationPathAnnotation(node.getPath(), asset)) continue;
            applicationFound = true;
            break;
        }
        if (!applicationFound) {
            String name = "org.wildfly.swarm.generated.WildFlySwarmDefaultJAXRSApplication";
            String path = "WEB-INF/classes/" + name.replace('.', '/') + ".class";
            byte[] generatedApp = new byte[]{};
            try {
                generatedApp = ApplicationFactory2.create(name, "/");
                this.add((Asset)new ByteArrayAsset(generatedApp), path);
                this.addHandlers(new ArchiveEventHandler[]{new ApplicationHandler(this, path)});
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void addExceptionMapperForFavicon() {
        try {
            this.add((Asset)new ByteArrayAsset(FaviconExceptionMapperFactory.create()), "WEB-INF/classes/org/wildfly/swarm/generated/FaviconExceptionMapper.class");
            this.addClass(FaviconHandler.class);
            this.addModule("org.jboss.modules");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JAXRSArchive addResource(Class<?> resource) {
        this.addClass(resource);
        return (JAXRSArchive)this.covarientReturn();
    }

    protected ArchivePath getManifestPath() {
        return PATH_MANIFEST;
    }

    protected ArchivePath getClassesPath() {
        return PATH_CLASSES;
    }

    protected ArchivePath getResourcePath() {
        return PATH_RESOURCE;
    }

    protected ArchivePath getLibraryPath() {
        return PATH_LIBRARY;
    }

    protected ArchivePath getWebPath() {
        return PATH_WEB;
    }

    protected ArchivePath getWebInfPath() {
        return PATH_WEB_INF;
    }

    protected ArchivePath getServiceProvidersPath() {
        return PATH_SERVICE_PROVIDERS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasApplicationPathAnnotation(ArchivePath path, Asset asset) {
        if (asset == null) {
            return false;
        }
        if (!path.get().endsWith(".class")) {
            return false;
        }
        try (InputStream in = asset.openStream();){
            ClassReader reader = new ClassReader(in);
            AnnotationSeekingClassVisitor visitor = new AnnotationSeekingClassVisitor();
            reader.accept((ClassVisitor)visitor, 0);
            boolean bl = visitor.isFound();
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static class ApplicationHandler
    implements ArchiveEventHandler {
        private final JAXRSArchive archive;
        private final String path;

        public ApplicationHandler(JAXRSArchive archive, String path) {
            this.archive = archive;
            this.path = path;
        }

        public void handle(ArchiveEvent event) {
            Asset asset = event.getAsset();
            if (JAXRSArchiveImpl.hasApplicationPathAnnotation(event.getPath(), asset)) {
                this.archive.delete(this.path);
            }
        }
    }
}

