/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.logging.runtime;

import java.util.ArrayList;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.config.runtime.invocation.Marshaller;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;
import org.wildfly.swarm.logging.LoggingFraction;

public class LoggingConfiguration
extends AbstractServerConfiguration<LoggingFraction> {
    public LoggingConfiguration() {
        super(LoggingFraction.class);
    }

    public LoggingFraction defaultFraction() {
        String prop = System.getProperty("swarm.logging");
        if (prop != null) {
            if ((prop = prop.trim().toLowerCase()).equals("debug")) {
                return LoggingFraction.createDebugLoggingFraction();
            }
            if (prop.equals("trace")) {
                return LoggingFraction.createTraceLoggingFraction();
            }
        }
        return LoggingFraction.createDefaultLoggingFraction();
    }

    public List<ModelNode> getList(LoggingFraction fraction) throws Exception {
        if (fraction == null) {
            fraction = this.defaultFraction();
        }
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ModelNode address = new ModelNode();
        address.setEmptyList();
        ModelNode add = new ModelNode();
        add.get("address").set(address).add("extension", "org.jboss.as.logging");
        add.get("operation").set("add");
        list.add(add);
        list.addAll(Marshaller.marshal((Object)fraction));
        return list;
    }
}

