/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.mail.runtime;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.config.Mail;
import org.wildfly.swarm.config.mail.MailSession;
import org.wildfly.swarm.config.mail.mail_session.SMTPServer;
import org.wildfly.swarm.config.runtime.invocation.Marshaller;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;
import org.wildfly.swarm.mail.MailFraction;
import org.wildfly.swarm.mail.SmtpServer;

public class MailConfiguration
extends AbstractServerConfiguration<MailFraction> {
    private PathAddress smtpServerAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"mail")});

    public MailConfiguration() {
        super(MailFraction.class);
    }

    public MailFraction defaultFraction() {
        return new MailFraction();
    }

    public List<ModelNode> getList(MailFraction fraction) throws Exception {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ModelNode node = new ModelNode();
        node.get("address").set("extension", "org.jboss.as.mail");
        node.get("operation").set("add");
        list.add(node);
        Mail mail = new Mail();
        List<ModelNode> socketBindings = this.addSmtpServers(fraction, mail);
        list.addAll(Marshaller.marshal((Object)mail));
        list.addAll(socketBindings);
        return list;
    }

    protected List<ModelNode> addSmtpServers(MailFraction fraction, Mail mail) {
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        for (SmtpServer each : fraction.smtpServers()) {
            list.add(this.addSmtpServer(each, mail));
        }
        return list;
    }

    protected ModelNode addSmtpServer(SmtpServer smtpServer, Mail mail) {
        SMTPServer smtp = new SMTPServer().outboundSocketBindingRef(smtpServer.outboundSocketBindingRef());
        MailSession mailSession = new MailSession(smtpServer.name().toLowerCase()).smtpServer(smtp).jndiName(smtpServer.jndiName());
        mail.mailSession(mailSession);
        ModelNode node = new ModelNode();
        node.get("address").set(PathAddress.pathAddress((String)"socket-binding-group", (String)"default-sockets").append("remote-destination-outbound-socket-binding", smtpServer.outboundSocketBindingRef()).toModelNode());
        node.get("operation").set("add");
        node.get("host").set(smtpServer.host());
        node.get("port").set(smtpServer.port());
        return node;
    }
}

