/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.wildfly.swarm.plugin.ArtifactSpec;

public abstract class AbstractSwarmMojo
extends AbstractMojo {
    protected static final String MODULE_PREFIX = "modules/system/layers/base/";
    protected static final String MODULE_SUFFIX = "/main/module.xml";
    protected static final String TARGET_NAME_PREFIX = "target-name=\"";
    @Component
    protected MavenProject project;
    @Component
    protected ProjectBuilder projectBuilder;
    @Component
    protected ProjectDependenciesResolver projectDependenciesResolver;
    @Parameter(defaultValue="${session}")
    protected MavenSession session;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(defaultValue="${repositorySystemSession}")
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${localRepository}")
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${plugin.artifacts}")
    protected List<org.apache.maven.artifact.Artifact> pluginArtifacts;
    protected Set<org.apache.maven.artifact.Artifact> featurePacks = new HashSet<org.apache.maven.artifact.Artifact>();
    protected Set<org.apache.maven.artifact.Artifact> featurePackArtifacts = new HashSet<org.apache.maven.artifact.Artifact>();
    protected Set<ArtifactSpec> gavs = new HashSet<ArtifactSpec>();

    protected void setupFeaturePacks(ArtifactResolver resolver) throws MojoFailureException {
        Set artifacts = this.project.getArtifacts();
        for (org.apache.maven.artifact.Artifact each : artifacts) {
            String featurePackReference = this.getFeaturePackReference(each);
            if (featurePackReference == null) continue;
            org.apache.maven.artifact.Artifact resultArtifact = this.resolveFeaturePack(resolver, featurePackReference);
            if (resultArtifact != null) {
                this.featurePacks.add(resultArtifact);
                continue;
            }
            throw new MojoFailureException("Unable to resolve referenced fraction: " + featurePackReference);
        }
    }

    protected org.apache.maven.artifact.Artifact resolveFeaturePack(ArtifactResolver resolver, String fractionGav) throws MojoFailureException {
        String[] parts = fractionGav.split(":");
        if (parts.length != 4) {
            throw new MojoFailureException("wildfly-swarm-feature-pack.gav must contain 4 segments");
        }
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact aetherArtifact = new DefaultArtifact(parts[0], parts[1], parts[2], parts[3]);
        request.setArtifact((Artifact)aetherArtifact);
        request.setRepositories(this.remoteRepositories());
        try {
            ArtifactResult result = resolver.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, request);
            return this.convertAetherToMavenArtifact(result.getArtifact(), "compile", "zip");
        }
        catch (ArtifactResolutionException e) {
            throw new MojoFailureException("Unable to resolve fraction: " + fractionGav, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getFeaturePackReference(org.apache.maven.artifact.Artifact artifact) throws MojoFailureException {
        if (!artifact.getType().equals("jar")) return null;
        try {
            ZipFile zip = new ZipFile(artifact.getFile());
            ZipEntry entry = zip.getEntry("wildfly-swarm-feature-pack.gav");
            if (entry == null) {
                return null;
            }
            try (InputStream in = zip.getInputStream(entry);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line = null;
                do {
                    if ((line = reader.readLine()) == null) return null;
                } while ((line = line.trim()).equals("") || line.startsWith("//"));
                String string = line;
                return string;
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to inspect dependency: " + artifact, (Throwable)e);
        }
    }

    protected void processFractions(ArtifactResolver resolver, ExceptionConsumer<Artifact> fractionHandler) throws MojoFailureException {
        Set artifacts = this.project.getArtifacts();
        ArrayList<Artifact> fractions = new ArrayList<Artifact>();
        for (org.apache.maven.artifact.Artifact each : artifacts) {
            String fractionReference = this.getFractionReference(each);
            if (fractionReference == null) continue;
            Artifact resultArtifact = this.resolveFraction(resolver, fractionReference);
            if (resultArtifact != null) {
                fractions.add(resultArtifact);
                continue;
            }
            throw new MojoFailureException("Unable to resolve referenced fraction: " + fractionReference);
        }
        try {
            for (Artifact artifact : fractions) {
                fractionHandler.accept(artifact);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to process fractions", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getFractionReference(org.apache.maven.artifact.Artifact artifact) throws MojoFailureException {
        if (!artifact.getType().equals("jar")) return null;
        try {
            ZipFile zip = new ZipFile(artifact.getFile());
            ZipEntry entry = zip.getEntry("wildfly-swarm-fraction.gav");
            if (entry == null) {
                return null;
            }
            try (InputStream in = zip.getInputStream(entry);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line = null;
                do {
                    if ((line = reader.readLine()) == null) return null;
                } while ((line = line.trim()).equals("") || line.startsWith("//"));
                String string = line;
                return string;
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to inspect dependency: " + artifact, (Throwable)e);
        }
    }

    protected Artifact resolveFraction(ArtifactResolver resolver, String fractionGav) throws MojoFailureException {
        String[] parts = fractionGav.split(":");
        if (parts.length != 5) {
            throw new MojoFailureException("wildfly-swarm-fraction.gav must contain 5 segments");
        }
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact aetherArtifact = new DefaultArtifact(parts[0], parts[1], parts[3], parts[2], parts[4]);
        request.setArtifact((Artifact)aetherArtifact);
        request.setRepositories(this.remoteRepositories());
        try {
            ArtifactResult result = resolver.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, request);
            return result.getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoFailureException("Unable to resolve fraction: " + fractionGav, (Throwable)e);
        }
    }

    protected ProjectBuildingResult buildProject(org.apache.maven.artifact.Artifact artifact) throws Exception {
        return this.projectBuilder.build(artifact, new DefaultProjectBuildingRequest().setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories).setRepositorySession((RepositorySystemSession)this.repositorySystemSession));
    }

    protected DependencyResolutionResult resolveProjectDependencies(MavenProject project, DependencyFilter filter) throws Exception {
        return this.projectDependenciesResolver.resolve(new DefaultDependencyResolutionRequest().setRepositorySession(this.session.getRepositorySession()).setMavenProject(project).setResolutionFilter(filter));
    }

    protected org.apache.maven.artifact.Artifact convertAetherToMavenArtifact(Artifact aetherArtifact, String scope, String handlerType) {
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(aetherArtifact.getGroupId(), aetherArtifact.getArtifactId(), aetherArtifact.getVersion(), scope, aetherArtifact.getExtension(), aetherArtifact.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler(handlerType));
        artifact.setFile(aetherArtifact.getFile());
        return artifact;
    }

    protected List<RemoteRepository> remoteRepositories() {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (ArtifactRepository each : this.remoteRepositories) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(each.getId(), "default", each.getUrl());
            repos.add(builder.build());
        }
        return repos;
    }

    protected void copyFileFromZip(ZipFile resource, ZipEntry entry, Path outFile) throws IOException {
        try (InputStream in = resource.getInputStream(entry);){
            Files.copy(in, outFile, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected static interface ExceptionConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

