/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import org.apache.maven.artifact.Artifact;

public class ArtifactSpec {
    private static final String JANDEX_SUFFIX = "?jandex";
    private String groupId;
    private String artifactId;
    private String classifier;
    private boolean jandex;

    public ArtifactSpec(String gav) {
        String[] parts = gav.split(":");
        this.groupId = parts[0];
        this.artifactId = parts[1];
        if (this.artifactId.endsWith(JANDEX_SUFFIX)) {
            this.artifactId = this.artifactId.substring(0, this.artifactId.length() - JANDEX_SUFFIX.length());
            this.jandex = true;
        }
        this.classifier = parts.length >= 4 ? parts[3] : null;
    }

    public boolean matches(Artifact artifact) {
        if (!this.groupId.equals(artifact.getGroupId())) {
            return false;
        }
        if (!this.artifactId.equals(artifact.getArtifactId())) {
            return false;
        }
        if (this.classifier == null) {
            return artifact.getClassifier() == null || artifact.getClassifier().equals("");
        }
        return this.classifier.equals(artifact.getClassifier());
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + (this.classifier == null ? "" : "::" + this.classifier);
    }
}

