/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.wildfly.swarm.plugin.AbstractSwarmMojo;
import org.wildfly.swarm.plugin.ModuleNode;

@Mojo(name="analyze", requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class AnalyzeMojo
extends AbstractSwarmMojo {
    @Inject
    private ArtifactResolver resolver;
    private ModuleNode root = new ModuleNode("");
    private Map<String, ModuleNode> modules = new HashMap<String, ModuleNode>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupFeaturePacks(this.resolver);
        this.processFractions(this.resolver, new FractionAnalyzer());
        this.display();
    }

    private void display() {
        this.root.dump();
    }

    private void addTransitiveModules(ModuleNode parent, ZipFile zipFile, ZipEntry moduleXml) {
        String currentName = moduleXml.getName().substring("modules/system/layers/base/".length(), moduleXml.getName().length() - "/main/module.xml".length());
        if (this.modules.containsKey(currentName = currentName.replace('/', '.'))) {
            parent.addChild(this.modules.get(currentName));
            return;
        }
        ModuleNode current = new ModuleNode(currentName);
        this.modules.put(currentName, current);
        parent.addChild(current);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(zipFile.getInputStream(moduleXml)));){
            String line = null;
            while ((line = in.readLine()) != null) {
                String moduleName;
                int end;
                int start;
                if ((line = line.trim()).startsWith("<module-alias") && (start = line.indexOf("target-name=\"")) > 0 && (end = line.indexOf("\"", start + "target-name=\"".length())) >= 0) {
                    moduleName = line.substring(start + "target-name=\"".length(), end);
                    this.addTransitiveModule(current, moduleName);
                    break;
                }
                if (!line.startsWith("<module name=") || (start = line.indexOf("\"")) <= 0 || (end = line.indexOf("\"", start + 1)) <= 0) continue;
                moduleName = line.substring(start + 1, end);
                if (line.contains("optional=\"true\"")) continue;
                this.addTransitiveModule(current, moduleName);
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void addTransitiveModule(ModuleNode parent, String moduleName) {
        String search = "modules/system/layers/base/" + moduleName.replaceAll("\\.", "/") + "/main/module.xml";
        for (org.apache.maven.artifact.Artifact pack : this.featurePacks) {
            try {
                ZipFile zip = new ZipFile(pack.getFile());
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry each = entries.nextElement();
                    if (!each.getName().equals(search)) continue;
                    this.addTransitiveModules(parent, zip, each);
                    return;
                }
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    final class FractionAnalyzer
    implements AbstractSwarmMojo.ExceptionConsumer<Artifact> {
        FractionAnalyzer() {
        }

        @Override
        public void accept(Artifact artifact) throws Exception {
            ZipFile zipFile = new ZipFile(artifact.getFile());
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry each = entries.nextElement();
                if (!each.getName().startsWith("modules/system/layers/base/") || !each.getName().endsWith("/main/module.xml")) continue;
                AnalyzeMojo.this.getLog().error((CharSequence)("Analyze: " + each));
                AnalyzeMojo.this.addTransitiveModules(AnalyzeMojo.this.root, zipFile, each);
            }
        }
    }
}

