/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageMojo
extends AbstractMojo {
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("<artifact name=\"([^\"]+)\".*");
    @Component
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(defaultValue="${repositorySystemSession}")
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(alias="modules")
    private String[] additionalModules;
    @Parameter(alias="bundleDependencies", defaultValue="true")
    private boolean bundleDependencies;
    @Parameter(alias="mainClass")
    private String mainClass;
    @Inject
    private ArtifactResolver resolver;
    private Path dir;
    private Set<String> dependencies = new HashSet<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupDirectory();
        this.addWildflySwarmBootstrapJar();
        this.addBootstrapJars();
        this.createManifest();
        this.createWildflySwarmProperties();
        this.createDependenciesTxt();
        this.collectDependencies();
        this.createJar();
    }

    private void setupDirectory() throws MojoFailureException {
        this.dir = Paths.get(this.projectBuildDir, "wildfly-swarm-archive");
        try {
            if (Files.exists(this.dir, new LinkOption[0])) {
                this.emptyDir(this.dir);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to setup wildfly-swarm-archive directory", (Throwable)e);
        }
    }

    private void addWildflySwarmBootstrapJar() throws MojoFailureException {
        Artifact artifact = this.findArtifact("org.wildfly.swarm", "wildfly-swarm-bootstrap", "jar");
        try {
            this.expandArtifact(artifact);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to add bootstrap", (Throwable)e);
        }
    }

    private void addBootstrapJars() throws MojoFailureException {
        try {
            Path bootstrapJars = this.dir.resolve("_bootstrap");
            Files.createDirectories(bootstrapJars, new FileAttribute[0]);
            Set artifacts = this.project.getArtifacts();
            for (Artifact each : artifacts) {
                if (!this.includeAsBootstrapJar(each)) continue;
                Path fs = bootstrapJars.resolve(each.getArtifactId() + "-" + each.getVersion() + "." + each.getType());
                Files.copy(each.getFile().toPath(), fs, new CopyOption[0]);
            }
            Files.copy(this.project.getArtifact().getFile().toPath(), bootstrapJars.resolve(this.project.getArtifactId() + "-" + this.project.getVersion() + "." + this.project.getPackaging()), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to create _bootstrap directory", (Throwable)e);
        }
    }

    private boolean includeAsBootstrapJar(Artifact artifact) {
        if (artifact.getGroupId().equals("org.wildfly.swarm") && artifact.getArtifactId().equals("wildfly-swarm-bootstrap")) {
            return false;
        }
        if (artifact.getGroupId().equals("org.wildfly.swarm")) {
            return true;
        }
        if (artifact.getGroupId().equals("org.jboss.shrinkwrap")) {
            return true;
        }
        if (artifact.getGroupId().equals("org.jboss.msc") && artifact.getArtifactId().equals("jboss-msc")) {
            return false;
        }
        return !artifact.getScope().equals("provided");
    }

    private void createManifest() throws MojoFailureException {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attrs.put(Attributes.Name.MAIN_CLASS, "org.wildfly.swarm.bootstrap.Main");
        if (this.mainClass != null && !this.mainClass.equals("")) {
            attrs.put(new Attributes.Name("Wildfly-Swarm-Main-Class"), this.mainClass);
        }
        attrs.putValue("Application-Artifact", this.project.getArtifact().getFile().getName());
        Path manifestPath = this.dir.resolve("META-INF").resolve("MANIFEST.MF");
        try {
            Files.createDirectories(manifestPath.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(manifestPath, StandardOpenOption.CREATE);){
                manifest.write(out);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not create manifest file: " + manifestPath.toString(), (Throwable)e);
        }
    }

    private void createWildflySwarmProperties() throws MojoFailureException {
        Path propsPath = this.dir.resolve("META-INF").resolve("wildfly-swarm.properties");
        Properties props = new Properties();
        props.setProperty("wildfly.swarm.app.artifact", this.project.getBuild().getFinalName() + "." + this.project.getPackaging());
        try (FileOutputStream out = new FileOutputStream(propsPath.toFile());){
            props.store(out, "Generated By Wildfly Swarm");
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to create META-INF/wildfly-swarm.properties", (Throwable)e);
        }
    }

    private void createDependenciesTxt() throws MojoFailureException {
        Object in;
        Throwable throwable;
        HashSet<String> provided = new HashSet<String>();
        Set artifacts = this.project.getArtifacts();
        for (Object each : artifacts) {
            if (!each.getType().equals("jar")) continue;
            try {
                JarFile jar = new JarFile(each.getFile());
                throwable = null;
                try {
                    ZipEntry entry = jar.getEntry("provided-dependencies.txt");
                    if (entry == null) continue;
                    provided.add(each.getGroupId() + ":" + each.getArtifactId());
                    in = jar.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if ((line = line.trim()).length() <= 0) continue;
                            provided.add(line);
                        }
                    }
                    catch (Throwable reader) {
                        throwable2 = reader;
                        throw reader;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable reader) {
                                throwable2.addSuppressed(reader);
                            }
                            continue;
                        }
                        ((InputStream)in).close();
                    }
                }
                catch (Throwable entry) {
                    throwable = entry;
                    throw entry;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable entry) {
                            throwable.addSuppressed(entry);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Unable to inspect jar", (Throwable)e);
            }
        }
        List resources = this.project.getResources();
        for (Resource each : resources) {
            Path providedDependencies = Paths.get(each.getDirectory(), "provided-dependencies.txt");
            if (!Files.exists(providedDependencies, new LinkOption[0])) continue;
            try {
                FileInputStream in2 = new FileInputStream(providedDependencies.toFile());
                in = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in2));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        provided.add(line);
                    }
                }
                catch (Throwable throwable3) {
                    in = throwable3;
                    throw throwable3;
                }
                finally {
                    if (in2 == null) continue;
                    if (in != null) {
                        try {
                            ((InputStream)in2).close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)in).addSuppressed(throwable4);
                        }
                        continue;
                    }
                    ((InputStream)in2).close();
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Error reading project's provided-dependencies.txt");
            }
        }
        Path depsPath = this.dir.resolve("META-INF").resolve("wildfly-swarm-dependencies.txt");
        try {
            throwable = null;
            try (FileWriter out = new FileWriter(depsPath.toFile());){
                for (Artifact each : artifacts) {
                    if (provided.contains(each.getGroupId() + ":" + each.getArtifactId()) || !each.getScope().equals("compile")) continue;
                    this.dependencies.add(each.getGroupId() + ":" + each.getArtifactId() + ":" + each.getVersion());
                    out.write(each.getGroupId() + ":" + each.getArtifactId() + ":" + each.getVersion() + "\n");
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to create META-INF/wildfly-swarm-dependencies.txt");
        }
    }

    protected void collectDependencies() throws MojoFailureException {
        if (!this.bundleDependencies) {
            return;
        }
        try {
            this.analyzeModuleDependencies();
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to collect dependencies", (Throwable)e);
        }
        this.gatherDependencies();
    }

    protected void analyzeModuleDependencies() throws IOException {
        for (Artifact each : this.project.getArtifacts()) {
            if (!this.includeAsBootstrapJar(each)) continue;
            this.analyzeModuleDependencies(each);
        }
    }

    protected void analyzeModuleDependencies(Artifact artifact) throws IOException {
        JarFile jar = new JarFile(artifact.getFile());
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry each = entries.nextElement();
            String name = each.getName();
            if (!name.startsWith("modules/") || !name.endsWith("module.xml")) continue;
            InputStream in = jar.getInputStream(each);
            Throwable throwable = null;
            try {
                this.analyzeModuleDependencies(in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    protected void analyzeModuleDependencies(InputStream moduleXml) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(moduleXml));
        String line = null;
        while ((line = reader.readLine()) != null) {
            Matcher matcher = ARTIFACT_PATTERN.matcher(line.trim());
            if (!matcher.matches()) continue;
            this.dependencies.add(matcher.group(1));
        }
    }

    protected void gatherDependencies() throws MojoFailureException {
        for (String each : this.dependencies) {
            try {
                this.gatherDependency(each);
            }
            catch (ArtifactResolutionException e) {
                throw new MojoFailureException("Unable to resolve artifact: " + each, (Throwable)e);
            }
        }
    }

    protected void gatherDependency(String gav) throws ArtifactResolutionException, MojoFailureException {
        String[] parts = gav.split(":");
        if (parts.length < 3) {
            throw new MojoFailureException("GAV must be at least 3 parts: " + gav);
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String packaging = "jar";
        String version = null;
        String classifier = null;
        if (parts.length > 3) {
            version = parts[2];
            classifier = parts[3];
        } else {
            version = parts[2];
        }
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact aetherArtifact = new DefaultArtifact(groupId, artifactId, classifier, packaging, version);
        request.setArtifact((org.eclipse.aether.artifact.Artifact)aetherArtifact);
        request.setRepositories(this.remoteRepositories());
        ArtifactResult result = this.resolver.resolveArtifact((RepositorySystemSession)this.repositorySystemSession, request);
        if (result.isResolved()) {
            try {
                this.gatherDependency(result.getArtifact());
            }
            catch (IOException e) {
                throw new MojoFailureException("Unable to gather dependenc: " + gav, (Throwable)e);
            }
        }
    }

    protected void gatherDependency(org.eclipse.aether.artifact.Artifact artifact) throws IOException {
        Path artifactPath = this.dir.resolve("m2repo");
        String[] groupIdParts = artifact.getGroupId().split("\\.");
        for (int i = 0; i < groupIdParts.length; ++i) {
            artifactPath = artifactPath.resolve(groupIdParts[i]);
        }
        artifactPath = artifactPath.resolve(artifact.getArtifactId());
        artifactPath = artifactPath.resolve(artifact.getVersion());
        artifactPath = artifactPath.resolve(artifact.getFile().getName());
        Files.createDirectories(artifactPath.getParent(), new FileAttribute[0]);
        Files.copy(artifact.getFile().toPath(), artifactPath, new CopyOption[0]);
    }

    private void createJar() throws MojoFailureException {
        Artifact primaryArtifact = this.project.getArtifact();
        DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
        org.apache.maven.artifact.DefaultArtifact artifact = new org.apache.maven.artifact.DefaultArtifact(primaryArtifact.getGroupId(), primaryArtifact.getArtifactId(), primaryArtifact.getVersion(), primaryArtifact.getScope(), "jar", "swarm", (ArtifactHandler)handler);
        String name = artifact.getArtifactId() + "-" + artifact.getVersion() + "-swarm.jar";
        File file = new File(this.projectBuildDir, name);
        try (FileOutputStream fileOut = new FileOutputStream(file);
             JarOutputStream out = new JarOutputStream(fileOut);){
            this.writeToJar(out, this.dir);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to create jar", (Throwable)e);
        }
        artifact.setFile(file);
        this.project.addAttachedArtifact((Artifact)artifact);
    }

    private void emptyDir(Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void expandArtifact(Artifact artifact) throws IOException {
        Path destination = this.dir;
        File artifactFile = artifact.getFile();
        if (artifact.getType().equals("jar")) {
            JarFile jarFile = new JarFile(artifactFile);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry each = entries.nextElement();
                if (each.getName().startsWith("META-INF")) continue;
                Path fsEach = destination.resolve(each.getName());
                if (each.isDirectory()) {
                    Files.createDirectories(fsEach, new FileAttribute[0]);
                    continue;
                }
                InputStream in = jarFile.getInputStream(each);
                Throwable throwable = null;
                try {
                    Files.createDirectories(fsEach.getParent(), new FileAttribute[0]);
                    Files.copy(in, fsEach, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    private Artifact findArtifact(String groupId, String artifactId, String type) {
        Set artifacts = this.project.getArtifacts();
        for (Artifact each : artifacts) {
            if (!each.getGroupId().equals(groupId) || !each.getArtifactId().equals(artifactId) || !each.getType().equals(type)) continue;
            return each;
        }
        return null;
    }

    private void writeToJar(final JarOutputStream out, Path entry) throws IOException {
        String entryPath;
        String rootPath = this.dir.toAbsolutePath().toString();
        if (!rootPath.equals(entryPath = entry.toAbsolutePath().toString())) {
            String jarPath = entryPath.substring(rootPath.length() + 1);
            if (Files.isDirectory(entry, new LinkOption[0])) {
                jarPath = jarPath + "/";
            }
            out.putNextEntry(new ZipEntry(jarPath.replace(File.separatorChar, '/')));
        }
        if (Files.isDirectory(entry, new LinkOption[0])) {
            Files.walkFileTree(entry, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    PackageMojo.this.writeToJar(out, file);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            Files.copy(entry, out);
        }
    }

    protected List<RemoteRepository> remoteRepositories() {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (ArtifactRepository each : this.remoteRepositories) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(each.getId(), "default", each.getUrl());
            repos.add(builder.build());
        }
        repos.add(new RemoteRepository.Builder("jboss-public-repository-group", "default", "http://repository.jboss.org/nexus/content/groups/public/").build());
        return repos;
    }
}

