/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.ProjectBuildingResult;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.ArtifactResolver;
import org.wildfly.swarm.plugin.AbstractSwarmMojo;
import org.wildfly.swarm.plugin.ArtifactSpec;
import org.wildfly.swarm.plugin.ArtifactUtils;

@Mojo(name="create", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CreateMojo
extends AbstractSwarmMojo {
    private static final String MAIN_SLOT = "main";
    private static final Pattern MODULE_ARTIFACT_EXPRESSION_PATTERN = Pattern.compile("(<artifact\\s+?name=\")(?:\\$\\{)+([A-Za-z0-9_\\-.]+:[A-Za-z0-9_\\-.]+)(?:(?::)([A-Za-z0-9_\\-.]*))?+(?:(?::)([A-Za-z0-9_\\-.]+))?+(\\?jandex)?+(?:})(\"/>)");
    private static final Pattern MODULE_ARTIFACT_GAV_PATTERN = Pattern.compile("(<artifact\\s+?name=\")+([A-Za-z0-9_\\-.]+:[A-Za-z0-9_\\-.]+:[A-Za-z0-9_\\-.]+(:[A-Za-z0-9_\\-.]+)?)+(\"/>)");
    private final Map<String, String> featurePackDepVersions = new HashMap<String, String>();
    @Inject
    private ArtifactResolver resolver;
    private Map<String, List<String>> modules = new HashMap<String, List<String>>();
    private List<String> fractionModules = new ArrayList<String>();
    @Parameter(alias="modules")
    private String[] additionalModules;
    @Parameter(alias="bundle-dependencies", defaultValue="true")
    private boolean bundleDependencies;
    private Path dir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupFeaturePacks(this.resolver);
        this.setupFeaturePackArtifacts();
        this.setupDirectory();
        this.addBootstrap();
        this.processFractions(this.resolver, new FractionExpander());
        this.addAdditionalModules();
        this.addMavenRepository();
        this.addProjectArtifact();
        this.addProjectDependenciesToRepository();
        this.createManifest();
        this.createJar();
    }

    private void setupFeaturePackArtifacts() throws MojoFailureException {
        for (Artifact pack : this.featurePacks) {
            DefaultArtifact packPom = new DefaultArtifact(pack.getGroupId(), pack.getArtifactId(), pack.getVersion(), "", "pom", pack.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler("pom"));
            try {
                ProjectBuildingResult buildingResult = this.buildProject((Artifact)packPom);
                DependencyResolutionResult resolutionResult = this.resolveProjectDependencies(buildingResult.getProject(), null);
                if (resolutionResult.getDependencies() == null || resolutionResult.getDependencies().size() <= 0) continue;
                for (Dependency dep : resolutionResult.getDependencies()) {
                    this.featurePackDepVersions.put(dep.getArtifact().getGroupId() + ":" + dep.getArtifact().getArtifactId(), dep.getArtifact().getVersion());
                    this.featurePackArtifacts.add(this.convertAetherToMavenArtifact(dep.getArtifact(), "compile", "jar"));
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private void addMavenRepository() throws MojoFailureException {
        if (!this.bundleDependencies) {
            return;
        }
        Path modulesDir = this.dir.resolve("modules");
        this.analyzeModuleXmls(modulesDir);
        this.collectArtifacts();
    }

    private void collectArtifacts() throws MojoFailureException {
        for (ArtifactSpec each : this.gavs) {
            if (this.collectArtifact(each)) continue;
            this.getLog().error((CharSequence)("unable to locate artifact: " + each));
        }
    }

    private boolean collectArtifact(ArtifactSpec spec) throws MojoFailureException {
        Artifact artifact = this.locateArtifact(spec);
        if (artifact == null) {
            return false;
        }
        this.addArtifact(artifact);
        return true;
    }

    private void addArtifact(Artifact artifact) throws MojoFailureException {
        Path m2repo = this.dir.resolve("m2repo");
        Path dest = m2repo.resolve(ArtifactUtils.toPath(artifact));
        try {
            Files.createDirectories(dest.getParent(), new FileAttribute[0]);
            Files.copy(artifact.getFile().toPath(), dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoFailureException("unable to add artifact: " + dest, (Throwable)e);
        }
    }

    private Artifact locateArtifact(ArtifactSpec spec) {
        for (Artifact each : this.featurePackArtifacts) {
            if (!spec.matches(each)) continue;
            return each;
        }
        for (Artifact each : this.pluginArtifacts) {
            if (!spec.matches(each)) continue;
            return each;
        }
        for (Artifact each : this.project.getArtifacts()) {
            if (!spec.matches(each)) continue;
            return each;
        }
        return null;
    }

    private void analyzeModuleXmls(Path path) throws MojoFailureException {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if ("module.xml".equals(file.getFileName().toString())) {
                        CreateMojo.this.analyzeModuleXml(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to analyze module XML for " + path, (Throwable)e);
        }
    }

    private void analyzeModuleXml(Path path) throws IOException {
        List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
        for (String line : lines) {
            Matcher matcher = MODULE_ARTIFACT_GAV_PATTERN.matcher(line);
            if (!matcher.find()) continue;
            this.gavs.add(new ArtifactSpec(matcher.group(2)));
        }
    }

    private void addTransitiveModules(Path moduleXml) {
        try (BufferedReader in = Files.newBufferedReader(moduleXml, StandardCharsets.UTF_8);){
            String line = null;
            while ((line = in.readLine()) != null) {
                String moduleName;
                int end;
                int start;
                if ((line = line.trim()).startsWith("<module-alias") && (start = line.indexOf("target-name=\"")) > 0 && (end = line.indexOf("\"", start + "target-name=\"".length())) >= 0) {
                    moduleName = line.substring(start + "target-name=\"".length(), end);
                    this.addTransitiveModule(moduleName);
                    break;
                }
                if (!line.startsWith("<module name=") || (start = line.indexOf("\"")) <= 0 || (end = line.indexOf("\"", start + 1)) <= 0) continue;
                moduleName = line.substring(start + 1, end);
                if (line.contains("optional=\"true\"")) continue;
                int slotStart = line.indexOf("slot=\"");
                if (slotStart > 0) {
                    int slotEnd = line.indexOf("\"", (slotStart += 6) + 1);
                    String slotName = line.substring(slotStart, slotEnd);
                    this.addTransitiveModule(moduleName, slotName);
                    continue;
                }
                this.addTransitiveModule(moduleName);
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
        }
    }

    private void addTransitiveModule(String moduleName) {
        this.addTransitiveModule(moduleName, MAIN_SLOT);
    }

    private void addTransitiveModule(String moduleName, String slot) {
        if (this.modules.containsKey(moduleName) && this.modules.get(moduleName).contains(slot)) {
            return;
        }
        String search = "modules/system/layers/base/" + moduleName.replace('.', '/') + "/" + slot + "/module.xml";
        for (Artifact pack : this.featurePacks) {
            try {
                ZipFile zip = new ZipFile(pack.getFile());
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry each = entries.nextElement();
                    if (!each.getName().equals(search)) continue;
                    Path outFile = this.dir.resolve(search);
                    Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
                    this.copyFileFromZip(zip, each, outFile);
                    ArrayList<String> slots = new ArrayList<String>();
                    slots.add(slot);
                    this.modules.put(moduleName, slots);
                    this.addTransitiveModules(outFile);
                    return;
                }
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    private void addAdditionalModules() {
        if (this.additionalModules == null) {
            return;
        }
        for (int i = 0; i < this.additionalModules.length; ++i) {
            this.addTransitiveModule(this.additionalModules[i]);
        }
    }

    private void setupDirectory() throws MojoFailureException {
        this.dir = Paths.get(this.projectBuildDir, "wildfly-swarm-archive");
        try {
            if (Files.notExists(this.dir, new LinkOption[0])) {
                Files.createDirectories(this.dir, new FileAttribute[0]);
            } else {
                this.emptyDir(this.dir);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to setup wildfly-swarm-archive directory", (Throwable)e);
        }
    }

    private void emptyDir(Path dir) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void expandArtifact(Artifact artifact) throws IOException {
        Path destination = this.dir;
        File artifactFile = artifact.getFile();
        if (artifact.getType().equals("jar")) {
            JarFile jarFile = new JarFile(artifactFile);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry each = entries.nextElement();
                if (each.getName().startsWith("META-INF")) continue;
                Path fsEach = destination.resolve(each.getName());
                if (each.isDirectory()) {
                    Files.createDirectories(fsEach, new FileAttribute[0]);
                    continue;
                }
                this.copyFileFromZip(jarFile, each, fsEach);
            }
        }
    }

    private Artifact findArtifact(String groupId, String artifactId, String type) {
        Set artifacts = this.project.getArtifacts();
        for (Artifact each : artifacts) {
            if (!each.getGroupId().equals(groupId) || !each.getArtifactId().equals(artifactId) || !each.getType().equals(type)) continue;
            return each;
        }
        return null;
    }

    private void addBootstrap() throws MojoFailureException {
        Artifact artifact = this.findArtifact("org.wildfly.swarm", "wildfly-swarm-bootstrap", "jar");
        try {
            this.expandArtifact(artifact);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to add bootstrap", (Throwable)e);
        }
    }

    private void addProjectArtifact() throws MojoFailureException {
        Artifact artifact = this.project.getArtifact();
        Path appDir = this.dir.resolve("app");
        Path appFile = appDir.resolve(artifact.getFile().getName());
        try {
            Files.createDirectories(appDir, new FileAttribute[0]);
            Files.copy(artifact.getFile().toPath(), appFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error copying project artifact", (Throwable)e);
        }
    }

    private void addProjectDependenciesToRepository() throws MojoFailureException {
        if (!this.bundleDependencies) {
            return;
        }
        if (!this.project.getPackaging().equals("jar")) {
            return;
        }
        Path depsTxt = this.dir.resolve("dependencies.txt");
        try (BufferedWriter out = Files.newBufferedWriter(depsTxt, StandardCharsets.UTF_8, new OpenOption[0]);){
            Set dependencies = this.project.getArtifacts();
            for (Artifact each : dependencies) {
                String scope = each.getScope();
                if (!scope.equals("compile") && !scope.equals("runtime")) continue;
                this.addArtifact(each);
                out.write(each.getGroupId() + ":" + each.getArtifactId() + ":" + each.getVersion() + "\n");
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to create dependencies.txt", (Throwable)e);
        }
    }

    private void createJar() throws MojoFailureException {
        Artifact primaryArtifact = this.project.getArtifact();
        DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
        DefaultArtifact artifact = new DefaultArtifact(primaryArtifact.getGroupId(), primaryArtifact.getArtifactId(), primaryArtifact.getVersion(), primaryArtifact.getScope(), "jar", "swarm", (ArtifactHandler)handler);
        String name = artifact.getArtifactId() + "-" + artifact.getVersion() + "-swarm.jar";
        File file = new File(this.projectBuildDir, name);
        try (FileOutputStream fileOut = new FileOutputStream(file);
             JarOutputStream out = new JarOutputStream(fileOut);){
            this.writeToJar(out, this.dir);
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to create jar", (Throwable)e);
        }
        artifact.setFile(file);
        this.project.addAttachedArtifact((Artifact)artifact);
    }

    private void writeToJar(final JarOutputStream out, Path entry) throws IOException {
        String entryPath;
        String rootPath = this.dir.toAbsolutePath().toString();
        if (!rootPath.equals(entryPath = entry.toAbsolutePath().toString())) {
            String jarPath = entryPath.substring(rootPath.length() + 1);
            if (Files.isDirectory(entry, new LinkOption[0])) {
                jarPath = jarPath + "/";
            }
            out.putNextEntry(new ZipEntry(jarPath.replace(File.separatorChar, '/')));
        }
        if (Files.isDirectory(entry, new LinkOption[0])) {
            Files.walkFileTree(entry, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    CreateMojo.this.writeToJar(out, file);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else {
            Files.copy(entry, out);
        }
    }

    private void createManifest() throws MojoFailureException {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attrs.put(Attributes.Name.MAIN_CLASS, "org.wildfly.swarm.bootstrap.Main");
        attrs.putValue("Application-Artifact", this.project.getArtifact().getFile().getName());
        StringBuilder modules = new StringBuilder();
        boolean first = true;
        for (String each : this.fractionModules) {
            if (!first) {
                modules.append(",");
            }
            modules.append(each);
            first = false;
        }
        attrs.putValue("Feature-Pack-Modules", modules.toString());
        Path manifestPath = this.dir.resolve("META-INF").resolve("MANIFEST.MF");
        try {
            Files.createDirectories(manifestPath.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(manifestPath, StandardOpenOption.CREATE);){
                manifest.write(out);
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Could not create manifest file: " + manifestPath.toString(), (Throwable)e);
        }
    }

    private void copyFileFromZip(ZipFile resource, ZipEntry entry, Path outFile) throws IOException {
        block41: {
            if (entry.getName().endsWith("module.xml")) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream(entry), StandardCharsets.UTF_8));
                     BufferedWriter writer = Files.newBufferedWriter(outFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Matcher matcher = MODULE_ARTIFACT_EXPRESSION_PATTERN.matcher(line);
                        while (matcher.find()) {
                            String version = matcher.group(3);
                            String classifier = matcher.group(4);
                            if (version != null && !version.isEmpty()) continue;
                            version = this.findVersion(matcher.group(2));
                            if (version != null) {
                                if (classifier != null) {
                                    line = matcher.replaceAll("$1$2:" + version + ":$4$6");
                                    continue;
                                }
                                line = matcher.replaceAll("$1$2:" + version + "$6");
                                continue;
                            }
                            this.getLog().debug((CharSequence)("No version found for " + line));
                        }
                        writer.write(line);
                        writer.write(System.lineSeparator());
                    }
                    break block41;
                }
            }
            try (InputStream in = resource.getInputStream(entry);){
                Files.copy(in, outFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private String findVersion(String ga) {
        String[] gaParts;
        String version = this.featurePackDepVersions.get(ga);
        if (version == null && (gaParts = ga.split(":")).length == 2) {
            Set artifacts = this.project.getArtifacts();
            for (Artifact artifact : artifacts) {
                if (!artifact.getGroupId().endsWith(gaParts[0]) || !artifact.getArtifactId().equals(gaParts[1])) continue;
                version = artifact.getVersion();
                break;
            }
        }
        return version;
    }

    private String normalizeZipEntryName(ZipEntry entry) {
        return entry.getName().replace(File.separatorChar, '/');
    }

    final class FractionExpander
    implements AbstractSwarmMojo.ExceptionConsumer<org.eclipse.aether.artifact.Artifact> {
        FractionExpander() {
        }

        @Override
        public void accept(org.eclipse.aether.artifact.Artifact artifact) throws Exception {
            ZipFile zipFile = new ZipFile(artifact.getFile());
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry each = entries.nextElement();
                Path fsEach = CreateMojo.this.dir.resolve(each.getName());
                if (each.isDirectory()) {
                    Files.createDirectories(fsEach, new FileAttribute[0]);
                    continue;
                }
                String normalizedName = CreateMojo.this.normalizeZipEntryName(each);
                if (normalizedName.startsWith("modules/system/layers/base/") && normalizedName.endsWith("/main/module.xml")) {
                    String moduleName = normalizedName.substring("modules/system/layers/base/".length(), normalizedName.length() - "/main/module.xml".length());
                    moduleName = moduleName.replace('/', '.') + ":main";
                    CreateMojo.this.fractionModules.add(moduleName);
                }
                CreateMojo.this.copyFileFromZip(zipFile, each, fsEach);
                if (!"module.xml".equals(fsEach.getFileName().toString())) continue;
                CreateMojo.this.addTransitiveModules(fsEach);
            }
        }
    }
}

