/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.gradle;

import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;

public class GradleArtifactResolvingHelper
implements ArtifactResolvingHelper {
    private final Project project;

    public GradleArtifactResolvingHelper(Project project) {
        this.project = project;
        this.project.getRepositories().maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository repo) {
                repo.setName("jboss-public");
                repo.setUrl((Object)"http://repository.jboss.org/nexus/content/groups/public/");
            }
        });
    }

    public ArtifactSpec resolve(ArtifactSpec spec) {
        if (spec.file != null) {
            return spec;
        }
        Configuration config = this.project.getConfigurations().detachedConfiguration(new Dependency[0]);
        DefaultExternalModuleDependency d = new DefaultExternalModuleDependency(spec.groupId, spec.artifactId, spec.version);
        DefaultDependencyArtifact da = new DefaultDependencyArtifact(spec.artifactId, spec.packaging, spec.packaging, spec.classifier, null);
        d.addArtifact((DependencyArtifact)da);
        d.getExcludeRules().add(new DefaultExcludeRule());
        config.getDependencies().add((Object)d);
        Set resolved = config.getResolvedConfiguration().getFirstLevelModuleDependencies();
        for (ResolvedDependency eachDep : resolved) {
            Set artifacts = eachDep.getModuleArtifacts();
            Iterator iterator = artifacts.iterator();
            if (!iterator.hasNext()) continue;
            ResolvedArtifact eachArtifact = (ResolvedArtifact)iterator.next();
            spec.file = eachArtifact.getFile();
            return spec;
        }
        return null;
    }
}

