/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.wildfly.swarm.plugin.maven.MavenArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(defaultValue="${repositorySystemSession}")
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    protected List<ArtifactRepository> remoteRepositories;
    @Inject
    private ArtifactResolver resolver;
    @Parameter(alias="modules")
    private String[] additionalModules;
    @Parameter(alias="bundleDependencies", defaultValue="true")
    private boolean bundleDependencies;
    @Parameter(alias="mainClass")
    private String mainClass;
    @Parameter(alias="httpPort")
    private Integer httpPort;
    @Parameter(alias="portOffset")
    private Integer portOffset;
    @Parameter(alias="bindAddress")
    private String bindAddress;
    @Parameter(alias="contextPath", defaultValue="/")
    private String contextPath;
    @Parameter(alias="properties")
    private Properties properties;
    @Parameter(alias="propertiesFile")
    private String propertiesFile;
    private BuildTool tool;

    protected Properties loadProperties(File file) throws MojoFailureException {
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            props.load(in);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException("No such file: " + file, (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error reading file: " + file, (Throwable)e);
        }
        return props;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.propertiesFile != null) {
            File propsFile = new File(this.propertiesFile);
            this.properties.putAll((Map<?, ?>)this.loadProperties(propsFile));
        }
        if (this.httpPort != null) {
            this.getLog().warn((CharSequence)"<httpPort> is deprecated, please use <jboss.http.port> within <properties>");
            this.properties.setProperty("jboss.http.port", this.httpPort.toString());
        }
        if (this.portOffset != null) {
            this.getLog().warn((CharSequence)"<portOffset> is deprecated, please use <jboss.port.offset> within <properties>");
            this.properties.setProperty("jboss.port.offset", this.portOffset.toString());
        }
        if (this.bindAddress != null) {
            this.getLog().warn((CharSequence)"<bindAddress> is deprecated, please use <jboss.bind.address> within <properties>");
            this.properties.setProperty("jboss.bind.address", this.bindAddress);
        }
        this.tool = new BuildTool();
        this.tool.projectArtifact(this.project.getArtifact().getGroupId(), this.project.getArtifact().getArtifactId(), this.project.getArtifact().getVersion(), this.project.getArtifact().getType(), this.project.getArtifact().getFile());
        Set deps = this.project.getArtifacts();
        for (Object each : deps) {
            this.tool.dependency(each.getScope(), each.getGroupId(), each.getArtifactId(), each.getVersion(), each.getType(), each.getClassifier(), each.getFile());
        }
        List resources = this.project.getResources();
        for (Object each : resources) {
            this.tool.resourceDirectory(each.getDirectory());
        }
        this.tool.properties(this.properties).mainClass(this.mainClass).contextPath(this.contextPath);
        MavenArtifactResolvingHelper resolvingHelper = new MavenArtifactResolvingHelper(this.resolver, (RepositorySystemSession)this.repositorySystemSession);
        for (ArtifactRepository each : this.remoteRepositories) {
            resolvingHelper.remoteRepository(each);
        }
        this.tool.artifactResolvingHelper((ArtifactResolvingHelper)resolvingHelper);
        try {
            File jar = this.tool.build(this.project.getBuild().getFinalName(), Paths.get(this.projectBuildDir, new String[0]));
            Artifact primaryArtifact = this.project.getArtifact();
            DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
            DefaultArtifact swarmJarArtifact = new DefaultArtifact(primaryArtifact.getGroupId(), primaryArtifact.getArtifactId(), primaryArtifact.getVersion(), primaryArtifact.getScope(), "jar", "swarm", (ArtifactHandler)handler);
            swarmJarArtifact.setFile(jar);
            this.project.addAttachedArtifact((Artifact)swarmJarArtifact);
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to create -swarm.jar", (Throwable)e);
        }
    }
}

