/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.gradle;

import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.wildfly.swarm.plugin.gradle.GradleArtifactResolvingHelper;
import org.wildfly.swarm.plugin.gradle.SwarmExtension;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;

public class PackageTask
extends DefaultTask {
    private BuildTool tool;
    private Jar jarTask;

    public void jarTask(Jar jarTask) {
        this.jarTask = jarTask;
    }

    @TaskAction
    public void packageForSwarm() throws Exception {
        Project project = this.getProject();
        SwarmExtension ext = (SwarmExtension)project.getExtensions().getByName("swarm");
        if (ext.getMainClassName() == null && project.getConvention().getPlugins().containsKey("application")) {
            ApplicationPluginConvention app = (ApplicationPluginConvention)project.getConvention().getPlugins().get("application");
            ext.setMainClassName(app.getMainClassName());
        }
        ConfigurationContainer configs = project.getConfigurations();
        Configuration compile = configs.getByName("compile");
        this.tool = new BuildTool();
        this.tool.artifactResolvingHelper((ArtifactResolvingHelper)new GradleArtifactResolvingHelper(project));
        Set deps = compile.getResolvedConfiguration().getFirstLevelModuleDependencies();
        for (ResolvedDependency each : deps) {
            this.walk(each);
        }
        this.tool.projectArtifact(project.getGroup().toString(), project.getName(), project.getVersion().toString(), this.jarTask.getExtension(), this.jarTask.getArchivePath());
        this.tool.mainClass(ext.getMainClassName());
        this.tool.properties(ext.getProperties());
        Boolean bundleDependencies = ext.getBundleDependencies();
        if (bundleDependencies != null) {
            this.tool.bundleDependencies(bundleDependencies.booleanValue());
        }
        this.tool.build(project.getName(), project.getBuildDir().toPath().resolve("libs"));
    }

    private void walk(ResolvedDependency dep) {
        Set artifacts = dep.getModuleArtifacts();
        for (ResolvedArtifact each : artifacts) {
            String[] parts = dep.getName().split(":");
            String groupId = parts[0];
            String artifactId = parts[1];
            String version = parts[2];
            this.tool.dependency("compile", groupId, artifactId, version, each.getExtension(), each.getClassifier(), each.getFile(), dep.getParents().isEmpty());
        }
        for (ResolvedArtifact each : dep.getChildren()) {
            this.walk((ResolvedDependency)each);
        }
    }
}

