/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.wildfly.swarm.plugin.maven.PackageMojo;

public abstract class AbstractSwarmMojo
extends AbstractMojo {
    protected static String VERSION;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(alias="mainClass")
    protected String mainClass;
    @Parameter(alias="properties")
    protected Properties properties;
    @Parameter(alias="propertiesFile")
    protected String propertiesFile;
    @Parameter(alias="environment")
    protected Properties environment;
    @Parameter(alias="environmentFile")
    protected String environmentFile;
    @Parameter(alias="modules")
    protected String[] additionalModules;

    AbstractSwarmMojo() {
        if (this.additionalModules == null) {
            this.additionalModules = new String[]{"modules"};
        }
    }

    protected static Properties loadProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        try {
            props.load(in);
        }
        finally {
            in.close();
        }
        return props;
    }

    protected static Properties loadProperties(String file) throws MojoFailureException {
        return AbstractSwarmMojo.loadProperties(new File(file));
    }

    protected static Properties loadProperties(File file) throws MojoFailureException {
        try {
            return AbstractSwarmMojo.loadProperties(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException("No such file: " + file, (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("Error reading file: " + file, (Throwable)e);
        }
    }

    protected void initProperties(boolean withMaven) throws MojoFailureException {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.propertiesFile != null) {
            this.properties.putAll((Map<?, ?>)AbstractSwarmMojo.loadProperties(this.propertiesFile));
        }
        System.getProperties().stringPropertyNames().forEach(key -> {
            if (key.startsWith("jboss.") || key.startsWith("swarm.") || key.startsWith("wildfly.") || withMaven && key.startsWith("maven.") || this.properties.containsKey(key)) {
                this.properties.put(key, System.getProperty(key));
            }
        });
    }

    protected void initEnvironment() throws MojoFailureException {
        if (this.environment == null) {
            this.environment = new Properties();
        }
        if (this.environmentFile != null) {
            this.environment.putAll((Map<?, ?>)AbstractSwarmMojo.loadProperties(this.environmentFile));
        }
    }

    static {
        try {
            VERSION = AbstractSwarmMojo.loadProperties(PackageMojo.class.getClassLoader().getResourceAsStream("META-INF/maven/org.wildfly.swarm/wildfly-swarm-plugin/pom.properties")).getProperty("version");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

