/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.internal.impl.DefaultRepositorySystem;
import org.wildfly.swarm.plugin.maven.AbstractSwarmMojo;
import org.wildfly.swarm.plugin.maven.MavenArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageMojo
extends AbstractSwarmMojo {
    @Inject
    protected ArtifactResolver resolver;
    @Parameter(alias="bundleDependencies", defaultValue="true")
    protected boolean bundleDependencies;
    @Component
    protected DefaultRepositorySystem repositorySystem;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initProperties(false);
        BuildTool tool = new BuildTool();
        tool.projectArtifact(this.project.getArtifact().getGroupId(), this.project.getArtifact().getArtifactId(), this.project.getArtifact().getBaseVersion(), this.project.getArtifact().getType(), this.project.getArtifact().getFile());
        this.project.getArtifacts().forEach(dep -> tool.dependency(dep.getScope(), dep.getGroupId(), dep.getArtifactId(), dep.getBaseVersion(), dep.getType(), dep.getClassifier(), dep.getFile(), dep.getDependencyTrail().size() == 2));
        List resources = this.project.getResources();
        for (Resource each : resources) {
            tool.resourceDirectory(each.getDirectory());
        }
        for (String additionalModule : this.additionalModules) {
            File source = new File(this.project.getBuild().getOutputDirectory(), additionalModule);
            if (!source.exists()) continue;
            tool.additionalModule(source.getAbsolutePath());
        }
        tool.properties(this.properties).mainClass(this.mainClass).bundleDependencies(this.bundleDependencies);
        MavenArtifactResolvingHelper resolvingHelper = new MavenArtifactResolvingHelper(this.resolver, (RepositorySystem)this.repositorySystem, (RepositorySystemSession)this.repositorySystemSession);
        this.remoteRepositories.forEach(resolvingHelper::remoteRepository);
        tool.artifactResolvingHelper((ArtifactResolvingHelper)resolvingHelper);
        try {
            File jar = tool.build(this.project.getBuild().getFinalName(), Paths.get(this.projectBuildDir, new String[0]));
            Artifact primaryArtifact = this.project.getArtifact();
            DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
            DefaultArtifact swarmJarArtifact = new DefaultArtifact(primaryArtifact.getGroupId(), primaryArtifact.getArtifactId(), primaryArtifact.getBaseVersion(), primaryArtifact.getScope(), "jar", "swarm", (ArtifactHandler)handler);
            swarmJarArtifact.setFile(jar);
            this.project.addAttachedArtifact((Artifact)swarmJarArtifact);
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to create -swarm.jar", (Throwable)e);
        }
    }
}

