/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Util {
    public static Properties loadProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        try {
            props.load(in);
        }
        finally {
            in.close();
        }
        return props;
    }

    public static Properties loadProperties(String file) throws IOException {
        return Util.loadProperties(new File(file));
    }

    public static Properties loadProperties(File file) throws IOException {
        return Util.loadProperties(new FileInputStream(file));
    }

    public static Properties filteredSystemProperties(Properties existing, boolean withMaven) {
        Properties properties = new Properties();
        System.getProperties().stringPropertyNames().forEach(key -> {
            if (key.startsWith("jboss.") || key.startsWith("swarm.") || key.startsWith("wildfly.") || withMaven && key.startsWith("maven.") || existing.containsKey(key)) {
                properties.put(key, System.getProperty(key));
            }
        });
        return properties;
    }
}

