/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.wildfly.swarm.plugin.Util;
import org.wildfly.swarm.plugin.maven.PackageMojo;

public abstract class AbstractSwarmMojo
extends AbstractMojo {
    protected static String VERSION;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(alias="mainClass")
    protected String mainClass;
    @Parameter(alias="properties")
    protected Properties properties;
    @Parameter(alias="propertiesFile")
    protected String propertiesFile;
    @Parameter(alias="environment")
    protected Properties environment;
    @Parameter(alias="environmentFile")
    protected String environmentFile;
    @Parameter(alias="modules")
    protected String[] additionalModules;

    AbstractSwarmMojo() {
        if (this.additionalModules == null) {
            this.additionalModules = new String[]{"modules"};
        }
    }

    protected void initProperties(boolean withMaven) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.propertiesFile != null) {
            try {
                this.properties.putAll((Map<?, ?>)Util.loadProperties(this.propertiesFile));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to load properties from " + this.propertiesFile), (Throwable)e);
            }
        }
        this.properties.putAll((Map<?, ?>)Util.filteredSystemProperties(this.properties, withMaven));
    }

    protected void initEnvironment() throws MojoFailureException {
        if (this.environment == null) {
            this.environment = new Properties();
        }
        if (this.environmentFile != null) {
            try {
                this.environment.putAll((Map<?, ?>)Util.loadProperties(this.environmentFile));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to load environment from " + this.environmentFile), (Throwable)e);
            }
        }
    }

    static {
        try {
            VERSION = Util.loadProperties(PackageMojo.class.getClassLoader().getResourceAsStream("META-INF/maven/org.wildfly.swarm/wildfly-swarm-plugin/pom.properties")).getProperty("version");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

