/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.swarm.plugin.maven.AbstractSwarmMojo;
import org.wildfly.swarm.tools.exec.SwarmExecutor;
import org.wildfly.swarm.tools.exec.SwarmProcess;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class StartMojo
extends AbstractSwarmMojo {
    @Parameter(alias="stdoutFile")
    public File stdoutFile;
    @Parameter(alias="stderrFile")
    public File stderrFile;
    @Parameter(alias="useUberJar", defaultValue="${wildfly-swarm.useUberJar}")
    public boolean useUberJar;
    @Parameter(alias="debug", property="swarm.debug.port")
    public Integer debugPort;
    @Parameter(alias="jvmArguments")
    public List<String> jvmArguments = new ArrayList<String>();
    boolean waitForProcess;

    public void execute() throws MojoExecutionException, MojoFailureException {
        SwarmProcess process;
        SwarmExecutor executor;
        this.initProperties(true);
        this.initEnvironment();
        if (this.useUberJar) {
            executor = this.uberJarExecutor();
        } else if (this.project.getPackaging().equals("war")) {
            executor = this.warExecutor();
        } else if (this.project.getPackaging().equals("jar")) {
            executor = this.jarExecutor();
        } else {
            throw new MojoExecutionException("Unsupported packaging: " + this.project.getPackaging());
        }
        executor.withJVMArguments(this.jvmArguments);
        try {
            process = executor.withDebug(this.debugPort).withProperties(this.properties).withStdoutFile(this.stdoutFile != null ? this.stdoutFile.toPath() : null).withStderrFile(this.stderrFile != null ? this.stderrFile.toPath() : null).withEnvironment(this.environment).withWorkingDirectory(this.project.getBasedir().toPath()).execute();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    process.stop(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }));
            process.awaitDeploy(2L, TimeUnit.MINUTES);
            if (!process.isAlive()) {
                throw new MojoFailureException("Process failed to start");
            }
            if (process.getError() != null) {
                throw new MojoFailureException("Error starting process", (Throwable)process.getError());
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("unable to execute", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new MojoFailureException("Error waiting for deployment", (Throwable)e);
        }
        ArrayList<SwarmProcess> procs = (ArrayList<SwarmProcess>)this.getPluginContext().get("swarm-process");
        if (procs == null) {
            procs = new ArrayList<SwarmProcess>();
            this.getPluginContext().put("swarm-process", procs);
        }
        procs.add(process);
        if (this.waitForProcess) {
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Error waiting for process to start", (Exception)e);
            }
        }
    }

    protected SwarmExecutor uberJarExecutor() throws MojoFailureException {
        this.getLog().info((CharSequence)"Starting -swarm.jar");
        String finalName = this.project.getBuild().getFinalName();
        if (finalName.endsWith(".war") || finalName.endsWith(".jar")) {
            finalName = finalName.substring(0, finalName.length() - 4);
        }
        return new SwarmExecutor().withExecutableJar(Paths.get(this.projectBuildDir, finalName + "-swarm.jar"));
    }

    protected SwarmExecutor warExecutor() throws MojoFailureException {
        this.getLog().info((CharSequence)"Starting .war");
        String finalName = this.project.getBuild().getFinalName();
        if (!finalName.endsWith(".war")) {
            finalName = finalName + ".war";
        }
        return new SwarmExecutor().withModules(this.expandModules()).withClassPathEntries(this.dependencies(false)).withProperty("swarm.app.path", Paths.get(this.projectBuildDir, finalName).toString()).withDefaultMainClass();
    }

    protected SwarmExecutor jarExecutor() throws MojoFailureException {
        this.getLog().info((CharSequence)"Starting .jar");
        SwarmExecutor executor = new SwarmExecutor().withModules(this.expandModules()).withClassPathEntries(this.dependencies(true));
        if (this.mainClass != null) {
            executor.withMainClass(this.mainClass);
        } else {
            executor.withDefaultMainClass();
        }
        return executor;
    }

    List<Path> dependencies(boolean includeProjectArtifact) {
        ArrayList<Path> elements = new ArrayList<Path>();
        Set artifacts = this.project.getArtifacts();
        for (Artifact each : artifacts) {
            if (each.getGroupId().equals("org.jboss.logmanager") && each.getArtifactId().equals("jboss-logmanager")) continue;
            elements.add(each.getFile().toPath());
        }
        if (includeProjectArtifact) {
            elements.add(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]));
        }
        return elements;
    }

    List<Path> expandModules() {
        return Stream.of(this.additionalModules).map(m -> Paths.get(this.project.getBuild().getOutputDirectory(), m)).collect(Collectors.toList());
    }
}

