/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.File;
import java.nio.file.Paths;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.swarm.fractionlist.FractionList;
import org.wildfly.swarm.plugin.maven.AbstractSwarmMojo;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.FractionDescriptor;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageMojo
extends AbstractSwarmMojo {
    @Parameter(alias="bundleDependencies", defaultValue="true", property="swarm.bundleDependencies")
    protected boolean bundleDependencies;
    @Parameter(alias="executable", defaultValue="false", property="swarm.executable")
    protected boolean executable;
    @Parameter(alias="executableScript")
    protected File executableScript;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initProperties(false);
        Artifact primaryArtifact = this.project.getArtifact();
        String finalName = this.project.getBuild().getFinalName();
        String type = primaryArtifact.getType();
        BuildTool tool = new BuildTool().projectArtifact(primaryArtifact.getGroupId(), primaryArtifact.getArtifactId(), primaryArtifact.getBaseVersion(), type, primaryArtifact.getFile(), finalName.endsWith("." + type) ? finalName : String.format("%s.%s", finalName, type)).fractionList((org.wildfly.swarm.tools.FractionList)FractionList.get()).properties(this.properties).mainClass(this.mainClass).bundleDependencies(this.bundleDependencies).executable(this.executable).executableScript(this.executableScript).fractionDetectionMode(this.fractionDetectMode).artifactResolvingHelper((ArtifactResolvingHelper)this.mavenArtifactResolvingHelper()).logger(new BuildTool.SimpleLogger(){

            public void info(String msg) {
                PackageMojo.this.getLog().info((CharSequence)msg);
            }

            public void error(String msg) {
                PackageMojo.this.getLog().error((CharSequence)msg);
            }

            public void error(String msg, Throwable t) {
                PackageMojo.this.getLog().error((CharSequence)msg, t);
            }
        });
        this.additionalFractions.stream().map(f -> FractionDescriptor.fromGav((org.wildfly.swarm.tools.FractionList)FractionList.get(), (String)f)).map(FractionDescriptor::toArtifactSpec).forEach(arg_0 -> ((BuildTool)tool).fraction(arg_0));
        this.project.getArtifacts().forEach(dep -> tool.dependency(this.artifactToArtifactSpec((Artifact)dep)));
        this.project.getResources().forEach(r -> tool.resourceDirectory(r.getDirectory()));
        this.additionalModules.stream().map(m -> new File(this.project.getBuild().getOutputDirectory(), (String)m)).filter(File::exists).map(File::getAbsolutePath).forEach(arg_0 -> ((BuildTool)tool).additionalModule(arg_0));
        try {
            File jar = tool.build(finalName, Paths.get(this.projectBuildDir, new String[0]));
            DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
            DefaultArtifact swarmJarArtifact = new DefaultArtifact(primaryArtifact.getGroupId(), primaryArtifact.getArtifactId(), primaryArtifact.getBaseVersion(), primaryArtifact.getScope(), "jar", "swarm", (ArtifactHandler)handler);
            swarmJarArtifact.setFile(jar);
            this.project.addAttachedArtifact((Artifact)swarmJarArtifact);
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to create -swarm.jar", (Throwable)e);
        }
    }
}

