/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.wildfly.swarm.tools.exec.SwarmProcess;

@Mojo(name="stop")
public class StopMojo
extends AbstractMojo {
    @Parameter(defaultValue="${mojoExecution}")
    protected MojoExecution execution;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.execution.getExecutionId().equals("default-cli")) {
            this.getLog().error((CharSequence)"wildfly-swarm:stop is not usable from the CLI");
            return;
        }
        List value = (List)this.getPluginContext().get("swarm-process");
        if (value == null) {
            this.getLog().error((CharSequence)"No known processes to stop");
            return;
        }
        for (SwarmProcess each : value) {
            this.stop(each);
        }
    }

    protected void stop(SwarmProcess process) throws MojoFailureException {
        if (process != null) {
            try {
                process.stop(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new MojoFailureException("unable to stop process", (Throwable)e);
            }
        }
    }
}

