/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.gradle;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.wildfly.swarm.fractionlist.FractionList;
import org.wildfly.swarm.plugin.gradle.GradleArtifactResolvingHelper;
import org.wildfly.swarm.plugin.gradle.SwarmExtension;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.PropertiesUtil;

public class PackageTask
extends DefaultTask {
    private BuildTool tool;
    private Jar jarTask;

    public Task jarTask(Jar jarTask) {
        this.jarTask = jarTask;
        return this;
    }

    @TaskAction
    public void packageForSwarm() throws Exception {
        Project project = this.getProject();
        SwarmExtension ext = (SwarmExtension)project.getExtensions().getByName("swarm");
        if (ext.getMainClassName() == null && project.getConvention().getPlugins().containsKey("application")) {
            ApplicationPluginConvention app = (ApplicationPluginConvention)project.getConvention().getPlugins().get("application");
            ext.setMainClassName(app.getMainClassName());
        }
        Properties fromFile = new Properties();
        if (ext.getPropertiesFile() != null) {
            try {
                fromFile.putAll((Map<?, ?>)PropertiesUtil.loadProperties((File)ext.getPropertiesFile()));
            }
            catch (IOException e) {
                this.getLogger().error("Failed to load properties from " + ext.getPropertiesFile(), (Throwable)e);
            }
        }
        this.tool = new BuildTool().artifactResolvingHelper((ArtifactResolvingHelper)new GradleArtifactResolvingHelper(project)).projectArtifact(project.getGroup().toString(), project.getName(), project.getVersion().toString(), this.jarTask.getExtension(), this.jarTask.getArchivePath()).mainClass(ext.getMainClassName()).bundleDependencies(ext.getBundleDependencies().booleanValue()).executable(ext.getExecutable().booleanValue()).executableScript(ext.getExecutableScript()).properties(ext.getProperties()).properties(fromFile).properties(PropertiesUtil.filteredSystemProperties((Properties)ext.getProperties(), (boolean)false)).fractionList((org.wildfly.swarm.tools.FractionList)FractionList.get()).fractionDetectionMode(BuildTool.FractionDetectionMode.when_missing).additionalModules((Collection)ext.getModuleDirs().stream().filter(f -> f.exists()).map(File::getAbsolutePath).collect(Collectors.toList())).logger(new BuildTool.SimpleLogger(){

            public void info(String msg) {
                PackageTask.this.getLogger().info(msg);
            }

            public void error(String msg) {
                PackageTask.this.getLogger().error(msg);
            }

            public void error(String msg, Throwable t) {
                PackageTask.this.getLogger().error(msg, t);
            }
        });
        project.getConfigurations().getByName("compile").getResolvedConfiguration().getResolvedArtifacts().forEach(this::addDependency);
        Boolean bundleDependencies = ext.getBundleDependencies();
        if (bundleDependencies != null) {
            this.tool.bundleDependencies(bundleDependencies.booleanValue());
        }
        this.tool.build(project.getName(), project.getBuildDir().toPath().resolve("libs"));
    }

    private void addDependency(ResolvedArtifact artifact) {
        String groupId = artifact.getModuleVersion().getId().getGroup();
        String artifactId = artifact.getModuleVersion().getId().getName();
        String version = artifact.getModuleVersion().getId().getVersion();
        String extension = artifact.getExtension();
        String classifier = artifact.getClassifier();
        File file = artifact.getFile();
        this.tool.dependency("compile", groupId, artifactId, version, extension, classifier, file);
    }
}

