/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.gradle;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependency;
import org.gradle.api.internal.project.DefaultProjectAccessListener;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.ProjectAccessListener;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;

public class GradleArtifactResolvingHelper
implements ArtifactResolvingHelper {
    private final Project project;
    Map<String, Project> projects;

    public GradleArtifactResolvingHelper(Project project) {
        this.project = project;
        this.projects = project.getRootProject().getAllprojects().stream().collect(Collectors.toMap(p -> p.getGroup() + ":" + p.getName() + ":" + p.getVersion(), p -> p));
        this.project.getRepositories().maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository repo) {
                repo.setName("jboss-public");
                repo.setUrl((Object)"http://repository.jboss.org/nexus/content/groups/public/");
            }
        });
    }

    public ArtifactSpec resolve(ArtifactSpec spec) {
        if (spec.file != null) {
            return spec;
        }
        Iterator<ResolvedDependency> iterator = this.doResolve(new HashSet<ArtifactSpec>(Collections.singletonList(spec))).iterator();
        if (iterator.hasNext()) {
            spec.file = ((ResolvedArtifact)iterator.next().getModuleArtifacts().iterator().next()).getFile();
            return spec;
        }
        return null;
    }

    public Set<ArtifactSpec> resolveAll(Set<ArtifactSpec> specs) throws Exception {
        if (specs.isEmpty()) {
            return specs;
        }
        HashSet resolvedSpecs = new HashSet();
        this.doResolve(specs).forEach(dep -> dep.getModuleArtifacts().forEach(artifact -> resolvedSpecs.add(new ArtifactSpec(dep.getConfiguration(), dep.getModuleGroup(), artifact.getName(), dep.getModuleVersion(), artifact.getExtension(), artifact.getClassifier(), artifact.getFile()))));
        return resolvedSpecs.stream().filter(a -> !"system".equals(a.scope)).collect(Collectors.toSet());
    }

    private Set<ResolvedDependency> doResolve(Collection<ArtifactSpec> deps) {
        Configuration config = this.project.getConfigurations().detachedConfiguration(new Dependency[0]);
        DependencySet dependencySet = config.getDependencies();
        deps.stream().forEach(spec -> {
            if (this.projects.containsKey(spec.groupId() + ":" + spec.artifactId() + ":" + spec.version())) {
                dependencySet.add((Object)new DefaultProjectDependency((ProjectInternal)this.projects.get(spec.groupId() + ":" + spec.artifactId() + ":" + spec.version()), (ProjectAccessListener)new DefaultProjectAccessListener(), false));
            } else {
                DefaultExternalModuleDependency d = new DefaultExternalModuleDependency(spec.groupId(), spec.artifactId(), spec.version());
                DefaultDependencyArtifact da = new DefaultDependencyArtifact(spec.artifactId(), spec.type(), spec.type(), spec.classifier(), null);
                d.addArtifact((DependencyArtifact)da);
                d.getExcludeRules().add(new DefaultExcludeRule());
                dependencySet.add((Object)d);
            }
        });
        return config.getResolvedConfiguration().getFirstLevelModuleDependencies();
    }
}

