/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.wildfly.swarm.plugin.maven.MavenArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.PropertiesUtil;

public abstract class AbstractSwarmMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected DefaultRepositorySystemSession repositorySystemSession;
    @Parameter(alias="remoteRepositories", defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.directory}")
    protected String projectBuildDir;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Parameter(alias="mainClass", property="swarm.mainClass")
    protected String mainClass;
    @Parameter(alias="properties")
    protected Properties properties;
    @Parameter(alias="propertiesFile", property="swarm.propertiesFile")
    protected String propertiesFile;
    @Parameter(alias="environment")
    protected Properties environment;
    @Parameter(alias="environmentFile", property="swarm.environmentFile")
    protected String environmentFile;
    @Parameter(alias="modules")
    protected List<String> additionalModules = new ArrayList<String>();
    @Parameter(alias="fractions")
    protected List<String> additionalFractions = new ArrayList<String>();
    @Parameter(defaultValue="when_missing", property="swarm.detect.mode")
    protected BuildTool.FractionDetectionMode fractionDetectMode;
    @Inject
    protected ArtifactResolver resolver;
    @Component
    protected RepositorySystem repositorySystem;

    AbstractSwarmMojo() {
        if (this.additionalModules.isEmpty()) {
            this.additionalModules.add("modules");
        }
    }

    protected void initProperties(boolean withMaven) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        if (this.propertiesFile != null) {
            try {
                this.properties.putAll((Map<?, ?>)PropertiesUtil.loadProperties((String)this.propertiesFile));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to load properties from " + this.propertiesFile), (Throwable)e);
            }
        }
        this.properties.putAll((Map<?, ?>)PropertiesUtil.filteredSystemProperties((Properties)this.properties, (boolean)withMaven));
    }

    protected void initEnvironment() throws MojoFailureException {
        if (this.environment == null) {
            this.environment = new Properties();
        }
        if (this.environmentFile != null) {
            try {
                this.environment.putAll((Map<?, ?>)PropertiesUtil.loadProperties((String)this.environmentFile));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to load environment from " + this.environmentFile), (Throwable)e);
            }
        }
    }

    public static Proxy convertFromMavenProxy(org.apache.maven.settings.Proxy proxy) {
        if (proxy != null) {
            return new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build());
        }
        return null;
    }

    protected MavenArtifactResolvingHelper mavenArtifactResolvingHelper() {
        MavenArtifactResolvingHelper resolvingHelper = new MavenArtifactResolvingHelper(this.resolver, this.repositorySystem, (RepositorySystemSession)this.repositorySystemSession, AbstractSwarmMojo.convertFromMavenProxy(this.mavenSession.getSettings().getActiveProxy()));
        this.remoteRepositories.forEach(resolvingHelper::remoteRepository);
        return resolvingHelper;
    }

    protected ArtifactSpec artifactToArtifactSpec(Artifact dep) {
        return new ArtifactSpec(dep.getScope(), dep.getGroupId(), dep.getArtifactId(), dep.getBaseVersion(), dep.getType(), dep.getClassifier(), dep.getFile());
    }
}

