/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.Authentication;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.wildfly.swarm.plugin.maven.NewestVersionSelector;
import org.wildfly.swarm.plugin.maven.RepositorySystemSessionWrapper;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;

public class MavenArtifactResolvingHelper
implements ArtifactResolvingHelper {
    protected final RepositorySystemSession session;
    protected final List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private final ArtifactResolver resolver;
    private final RepositorySystem system;
    private final Proxy proxy;

    public MavenArtifactResolvingHelper(ArtifactResolver resolver, RepositorySystem system, RepositorySystemSession session, Proxy proxy) {
        this.resolver = resolver;
        this.system = system;
        this.session = session;
        this.proxy = proxy;
        this.remoteRepositories.add(MavenArtifactResolvingHelper.buildRemoteRepository("jboss-public-repository-group", "http://repository.jboss.org/nexus/content/groups/public/", null, this.proxy));
    }

    public void remoteRepository(ArtifactRepository repo) {
        this.remoteRepository(MavenArtifactResolvingHelper.buildRemoteRepository(repo.getId(), repo.getUrl(), repo.getAuthentication(), this.proxy));
    }

    public void remoteRepository(RemoteRepository repo) {
        this.remoteRepositories.add(repo);
    }

    public ArtifactSpec resolve(ArtifactSpec spec) {
        if (spec.file == null) {
            DefaultArtifact artifact = new DefaultArtifact(spec.groupId(), spec.artifactId(), spec.classifier(), spec.type(), spec.version());
            LocalArtifactResult localResult = this.session.getLocalRepositoryManager().find(this.session, new LocalArtifactRequest((Artifact)artifact, this.remoteRepositories, null));
            if (localResult.isAvailable()) {
                spec.file = localResult.getFile();
            } else {
                try {
                    ArtifactResult result = this.resolver.resolveArtifact(this.session, new ArtifactRequest((Artifact)artifact, this.remoteRepositories, null));
                    if (result.isResolved()) {
                        spec.file = result.getArtifact().getFile();
                    }
                }
                catch (ArtifactResolutionException e) {
                    e.printStackTrace();
                }
            }
        }
        return spec.file != null ? spec : null;
    }

    public Set<ArtifactSpec> resolveAll(Set<ArtifactSpec> specs, boolean transitive) throws Exception {
        if (specs.isEmpty()) {
            return specs;
        }
        List<Object> nodes = null;
        if (transitive) {
            CollectRequest request = new CollectRequest();
            request.setRepositories(this.remoteRepositories);
            specs.forEach(spec -> request.addDependency(new Dependency((Artifact)new DefaultArtifact(spec.groupId(), spec.artifactId(), spec.classifier(), spec.type(), spec.version()), "compile")));
            RepositorySystemSessionWrapper tempSession = new RepositorySystemSessionWrapper(this.session, (DependencyGraphTransformer)new ConflictResolver((ConflictResolver.VersionSelector)new NewestVersionSelector(), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver()));
            CollectResult result = this.system.collectDependencies((RepositorySystemSession)tempSession, request);
            PreorderNodeListGenerator gen = new PreorderNodeListGenerator();
            result.getRoot().accept((DependencyVisitor)gen);
            nodes = gen.getNodes();
        } else {
            nodes = new ArrayList<DependencyNode>();
            for (ArtifactSpec spec2 : specs) {
                Dependency dependency = new Dependency((Artifact)new DefaultArtifact(spec2.groupId(), spec2.artifactId(), spec2.classifier(), spec2.type(), spec2.version()), "compile");
                DefaultDependencyNode node2 = new DefaultDependencyNode(dependency);
                nodes.add((DependencyNode)node2);
            }
        }
        this.resolveDependenciesInParallel(nodes);
        return nodes.stream().filter(node -> !"system".equals(node.getDependency().getScope())).map(node -> {
            Artifact artifact = node.getArtifact();
            return new ArtifactSpec(node.getDependency().getScope(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getExtension(), artifact.getClassifier(), null);
        }).map(this::resolve).filter(x -> x != null).collect(Collectors.toSet());
    }

    private void resolveDependenciesInParallel(List<DependencyNode> nodes) {
        List artifactRequests = nodes.stream().map(node -> new ArtifactRequest(node.getArtifact(), this.remoteRepositories, null)).collect(Collectors.toList());
        try {
            this.resolver.resolveArtifacts(this.session, artifactRequests);
        }
        catch (ArtifactResolutionException artifactResolutionException) {
            // empty catch block
        }
    }

    protected static RemoteRepository buildRemoteRepository(String id, String url, Authentication auth, Proxy proxy) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, "default", url);
        if (auth != null && auth.getUsername() != null && auth.getPassword() != null) {
            builder.setAuthentication(new AuthenticationBuilder().addUsername(auth.getUsername()).addPassword(auth.getPassword()).build());
        }
        if (proxy != null) {
            builder.setProxy(proxy);
        }
        return builder.build();
    }
}

