/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.Authentication;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;
import org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.wildfly.swarm.plugin.maven.NewestVersionSelector;
import org.wildfly.swarm.plugin.maven.RepositorySystemSessionWrapper;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;

public class MavenArtifactResolvingHelper
implements ArtifactResolvingHelper {
    protected final RepositorySystemSession session;
    protected final List<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
    private final ArtifactResolver resolver;
    private final RepositorySystem system;

    public MavenArtifactResolvingHelper(ArtifactResolver resolver, RepositorySystem system, RepositorySystemSession session) {
        this.resolver = resolver;
        this.system = system;
        this.session = session;
        this.remoteRepositories.add(this.buildRemoteRepository("jboss-public-repository-group", "http://repository.jboss.org/nexus/content/groups/public/", null));
    }

    public void remoteRepository(ArtifactRepository repo) {
        this.remoteRepository(this.buildRemoteRepository(repo.getId(), repo.getUrl(), repo.getAuthentication()));
    }

    public void remoteRepository(RemoteRepository repo) {
        this.remoteRepositories.add(repo);
    }

    public ArtifactSpec resolve(ArtifactSpec spec) {
        if (spec.file == null) {
            DefaultArtifact artifact = new DefaultArtifact(spec.groupId(), spec.artifactId(), spec.classifier(), spec.type(), spec.version());
            LocalArtifactResult localResult = this.session.getLocalRepositoryManager().find(this.session, new LocalArtifactRequest((Artifact)artifact, this.remoteRepositories, null));
            if (localResult.isAvailable()) {
                spec.file = localResult.getFile();
            } else {
                try {
                    ArtifactResult result = this.resolver.resolveArtifact(this.session, new ArtifactRequest((Artifact)artifact, this.remoteRepositories, null));
                    if (result.isResolved()) {
                        spec.file = result.getArtifact().getFile();
                    }
                }
                catch (ArtifactResolutionException e) {
                    e.printStackTrace();
                }
            }
        }
        return spec.file != null ? spec : null;
    }

    public Set<ArtifactSpec> resolveAll(Collection<ArtifactSpec> specs, boolean transitive, boolean defaultExcludes) throws Exception {
        if (specs.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        List<Object> nodes = null;
        if (transitive) {
            CollectRequest request = new CollectRequest();
            request.setRepositories(this.remoteRepositories);
            specs.forEach(spec -> request.addDependency(new Dependency((Artifact)new DefaultArtifact(spec.groupId(), spec.artifactId(), spec.classifier(), spec.type(), spec.version()), "compile")));
            RepositorySystemSessionWrapper tempSession = new RepositorySystemSessionWrapper(this.session, (DependencyGraphTransformer)new ConflictResolver((ConflictResolver.VersionSelector)new NewestVersionSelector(), (ConflictResolver.ScopeSelector)new JavaScopeSelector(), (ConflictResolver.OptionalitySelector)new SimpleOptionalitySelector(), (ConflictResolver.ScopeDeriver)new JavaScopeDeriver()), defaultExcludes);
            CollectResult result = this.system.collectDependencies((RepositorySystemSession)tempSession, request);
            PreorderNodeListGenerator gen = new PreorderNodeListGenerator();
            result.getRoot().accept((DependencyVisitor)gen);
            nodes = gen.getNodes();
        } else {
            nodes = new ArrayList<DependencyNode>();
            for (ArtifactSpec spec2 : specs) {
                Dependency dependency = new Dependency((Artifact)new DefaultArtifact(spec2.groupId(), spec2.artifactId(), spec2.classifier(), spec2.type(), spec2.version()), "compile");
                DefaultDependencyNode node2 = new DefaultDependencyNode(dependency);
                nodes.add((DependencyNode)node2);
            }
        }
        this.resolveDependenciesInParallel(nodes);
        return nodes.stream().filter(node -> !"system".equals(node.getDependency().getScope())).map(node -> {
            Artifact artifact = node.getArtifact();
            return new ArtifactSpec(node.getDependency().getScope(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getExtension(), artifact.getClassifier(), null);
        }).map(this::resolve).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void resolveDependenciesInParallel(List<DependencyNode> nodes) {
        List artifactRequests = nodes.stream().map(node -> new ArtifactRequest(node.getArtifact(), this.remoteRepositories, null)).collect(Collectors.toList());
        try {
            this.resolver.resolveArtifacts(this.session, artifactRequests);
        }
        catch (ArtifactResolutionException artifactResolutionException) {
            // empty catch block
        }
    }

    protected RemoteRepository buildRemoteRepository(String id, String url, Authentication auth) {
        Proxy proxy;
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, "default", url);
        if (auth != null && auth.getUsername() != null && auth.getPassword() != null) {
            builder.setAuthentication(new AuthenticationBuilder().addUsername(auth.getUsername()).addPassword(auth.getPassword()).build());
        }
        RemoteRepository repository = builder.build();
        RemoteRepository mirror = this.session.getMirrorSelector().getMirror(repository);
        if (mirror != null) {
            builder = new RemoteRepository.Builder(mirror);
            if (auth != null && auth.getUsername() != null && auth.getPassword() != null) {
                builder.setAuthentication(new AuthenticationBuilder().addUsername(auth.getUsername()).addPassword(auth.getPassword()).build());
            }
            repository = builder.build();
        }
        if ((proxy = this.session.getProxySelector().getProxy(repository)) != null) {
            repository = new RemoteRepository.Builder(repository).setProxy(proxy).build();
        }
        return repository;
    }
}

