/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.gradle;

import groovy.lang.Closure;
import groovy.util.ConfigObject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;

public class SwarmExtension {
    private static final String MODULE_DIR_NAME = "modules";
    private Project project;
    private String mainClass;
    private Boolean bundleDependencies = true;
    private Boolean executable = false;
    private File executableScript;
    private Properties properties = new Properties();
    private File propertiesFile;
    private List<File> moduleDirs = new ArrayList<File>();
    private Jar archiveTask;

    public SwarmExtension(Project project) {
        this.project = project;
        Path resourcesOutputDir = ((SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().findByName("main")).getOutput().getResourcesDir().toPath().resolve(MODULE_DIR_NAME);
        if (Files.isDirectory(resourcesOutputDir, new LinkOption[0])) {
            File moduleDir = resourcesOutputDir.toFile();
            this.moduleDirs.add(moduleDir);
        }
    }

    public void properties(Closure<Properties> closure) {
        ConfigObject config = new ConfigObject();
        closure.setResolveStrategy(3);
        closure.setDelegate((Object)config);
        closure.call();
        config.flatten((Map)this.properties);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getMainClassName() {
        return this.mainClass;
    }

    public void setMainClassName(String mainClass) {
        this.mainClass = mainClass;
    }

    public Boolean getBundleDependencies() {
        return this.bundleDependencies;
    }

    public void setBundleDependencies(Boolean bundleDependencies) {
        this.bundleDependencies = bundleDependencies;
    }

    public Boolean getExecutable() {
        return this.executable;
    }

    public void setExecutable(Boolean executable) {
        this.executable = executable;
    }

    public File getExecutableScript() {
        return this.executableScript;
    }

    public void setExecutableScript(File executableScript) {
        this.executableScript = executableScript;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public List<File> getModuleDirs() {
        return this.moduleDirs;
    }

    public void setModuleDirs(List<File> moduleDirs) {
        this.moduleDirs.clear();
        this.moduleDirs.addAll(moduleDirs);
    }

    public Jar getArchiveTask() {
        return this.archiveTask;
    }

    public void setArchiveTask(Jar archiveTask) {
        this.archiveTask = archiveTask;
    }
}

