/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public class ExtraArtifactsHandler {
    private final List<DependencyNode> input;
    private final List<DependencyNode> output = new ArrayList<DependencyNode>();

    public static List<DependencyNode> getExtraDependencies(List<DependencyNode> nodes) {
        ExtraArtifactsHandler fetcher = new ExtraArtifactsHandler(nodes);
        if (ExtraArtifactsHandler.isSet("swarm.download.sources")) {
            System.out.println("will download sources");
            fetcher.addWithClassifier("sources");
        }
        if (ExtraArtifactsHandler.isSet("swarm.download.poms")) {
            System.out.println("will download poms");
            fetcher.addWithExtension("pom");
        }
        if (ExtraArtifactsHandler.isSet("swarm.download.javadocs")) {
            System.out.println("will download javadocs");
            fetcher.addWithClassifier("javadoc");
        }
        return fetcher.output;
    }

    private static boolean isSet(String key) {
        String value = System.getProperty(key);
        return value != null && !"false".equals(value);
    }

    public void addWithExtension(String extension) {
        this.addDependencies(a -> a.getExtension().equals(extension) && StringUtils.isEmpty((String)a.getClassifier()), Optional.of(extension), Optional.empty());
    }

    public void addWithClassifier(String classifier) {
        this.addDependencies(a -> a.getClassifier().equals(classifier) && "jar".equals(a.getExtension()), Optional.empty(), Optional.of(classifier));
    }

    private void addDependencies(Function<Artifact, Boolean> duplicateFilter, Optional<String> extension, Optional<String> classifier) {
        List dependencies = this.input.stream().map(DependencyNode::getDependency).collect(Collectors.toList());
        Set existingGavs = dependencies.stream().map(Dependency::getArtifact).filter(duplicateFilter::apply).map(this::toGav).collect(Collectors.toSet());
        List newNodes = this.input.stream().filter(n -> !existingGavs.contains(this.toGav(n.getDependency().getArtifact()))).map(n -> this.createNode((DependencyNode)n, extension, classifier)).collect(Collectors.toList());
        this.output.addAll(newNodes);
    }

    private DependencyNode createNode(DependencyNode n, Optional<String> extension, Optional<String> classifier) {
        Artifact original = n.getArtifact();
        DefaultArtifact withExtension = new DefaultArtifact(original.getGroupId(), original.getArtifactId(), classifier.orElse(original.getClassifier()), extension.orElse(original.getExtension()), original.getVersion(), original.getProperties(), (File)null);
        DefaultDependencyNode nodeWithClassifier = new DefaultDependencyNode(new Dependency((Artifact)withExtension, "system"));
        return nodeWithClassifier;
    }

    private String toGav(Artifact artifact) {
        return String.format("%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
    }

    public ExtraArtifactsHandler(List<DependencyNode> nodes) {
        this.input = nodes;
    }
}

