/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.wildfly.swarm.plugin.maven.AbstractSwarmMojo;
import org.wildfly.swarm.tools.exec.SwarmProcess;

@Mojo(name="stop")
public class StopMojo
extends AbstractSwarmMojo {
    @Parameter(defaultValue="${mojoExecution}")
    protected MojoExecution execution;
    private static final Pattern tempFilePattern = Pattern.compile("wfswarm\\S+[0-9]{5,}.\\S{5,}");

    @Override
    public void executeSpecific() throws MojoExecutionException, MojoFailureException {
        Path tmpDir;
        if (this.execution.getExecutionId().equals("default-cli")) {
            this.getLog().error((CharSequence)"wildfly-swarm:stop is not usable from the CLI");
            return;
        }
        List value = (List)this.getPluginContext().get("swarm-process");
        if (value == null) {
            this.getLog().error((CharSequence)"No known processes to stop");
            return;
        }
        for (SwarmProcess each : value) {
            this.stop(each);
        }
        File tmp = (File)this.getPluginContext().get("swarm-cp-file");
        if (tmp != null && tmp.exists()) {
            tmp.delete();
        }
        if ((tmpDir = new File(System.getProperty("java.io.tmpdir")).toPath()).toFile().exists()) {
            File[] filesTmp;
            for (File tmpFile : filesTmp = tmpDir.toFile().listFiles()) {
                Matcher matcher = tempFilePattern.matcher(tmpFile.getName().toString());
                if (!matcher.matches()) continue;
                this.deleteRecursively(tmpFile);
            }
        }
    }

    public boolean deleteRecursively(File f) {
        if (!f.exists()) {
            return false;
        }
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            for (int i = 0; i < children.length; ++i) {
                if (this.deleteRecursively(children[i])) continue;
                return false;
            }
        }
        return f.delete();
    }

    protected void stop(SwarmProcess process) throws MojoFailureException {
        if (process != null) {
            try {
                process.stop(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new MojoFailureException("unable to stop process", (Throwable)e);
            }
        }
    }
}

