/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin.maven;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.swarm.fractions.FractionDescriptor;
import org.wildfly.swarm.fractions.FractionList;
import org.wildfly.swarm.plugin.maven.AbstractSwarmMojo;
import org.wildfly.swarm.spi.meta.SimpleLogger;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.DeclaredDependencies;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageMojo
extends AbstractSwarmMojo {
    @Parameter(alias="bundleDependencies", defaultValue="true", property="swarm.bundleDependencies")
    protected boolean bundleDependencies;
    @Parameter(alias="executable", defaultValue="false", property="swarm.executable")
    protected boolean executable;
    @Parameter(alias="executableScript")
    protected File executableScript;
    @Parameter(alias="hollow", defaultValue="false", property="swarm.hollow")
    protected boolean hollow;
    @Parameter(property="finalName")
    public String finalName;
    @Parameter(alias="skip", defaultValue="false", property="swarm.package.skip")
    protected boolean skip;
    @Parameter(alias="uberjarResources")
    protected String uberjarResources;

    protected File divineFile() {
        if (this.project.getArtifact().getFile() != null) {
            return this.project.getArtifact().getFile();
        }
        String finalName = this.project.getBuild().getFinalName();
        Path candidate = Paths.get(this.projectBuildDir, finalName + "." + this.project.getPackaging());
        if (Files.exists(candidate, new LinkOption[0])) {
            return candidate.toFile();
        }
        return null;
    }

    @Override
    public void executeSpecific() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping packaging");
            return;
        }
        if (this.project.getPackaging().equals("pom")) {
            this.getLog().info((CharSequence)"Not processing project with pom packaging");
            return;
        }
        this.initProperties(false);
        Artifact primaryArtifact = this.project.getArtifact();
        String finalName = this.project.getBuild().getFinalName();
        String type = primaryArtifact.getType();
        File primaryArtifactFile = this.divineFile();
        if (primaryArtifactFile == null) {
            throw new MojoExecutionException("Cannot package without a primary artifact; please `mvn package` prior to invoking wildfly-swarm:package from the command-line");
        }
        DeclaredDependencies declaredDependencies = new DeclaredDependencies();
        BuildTool tool = new BuildTool((ArtifactResolvingHelper)this.mavenArtifactResolvingHelper()).projectArtifact(primaryArtifact.getGroupId(), primaryArtifact.getArtifactId(), primaryArtifact.getBaseVersion(), type, primaryArtifactFile, finalName.endsWith("." + type) ? finalName : String.format("%s.%s", finalName, type)).properties(this.properties).mainClass(this.mainClass).bundleDependencies(this.bundleDependencies).executable(this.executable).executableScript(this.executableScript).fractionDetectionMode(this.fractionDetectMode).hollow(this.hollow).logger(new SimpleLogger(){

            public void debug(String msg) {
                PackageMojo.this.getLog().debug((CharSequence)msg);
            }

            public void info(String msg) {
                PackageMojo.this.getLog().info((CharSequence)msg);
            }

            public void error(String msg) {
                PackageMojo.this.getLog().error((CharSequence)msg);
            }

            public void error(String msg, Throwable t) {
                PackageMojo.this.getLog().error((CharSequence)msg, t);
            }
        });
        this.fractions.forEach(f -> {
            if (f.startsWith("!")) {
                tool.excludeFraction(ArtifactSpec.fromFractionDescriptor((FractionDescriptor)FractionDescriptor.fromGav((FractionList)FractionList.get(), (String)f.substring(1))));
            } else {
                tool.fraction(ArtifactSpec.fromFractionDescriptor((FractionDescriptor)FractionDescriptor.fromGav((FractionList)FractionList.get(), (String)f)));
            }
        });
        Map<ArtifactSpec, Set<ArtifactSpec>> buckets = this.createBuckets(this.project.getArtifacts(), this.project.getDependencies());
        for (ArtifactSpec directDep : buckets.keySet()) {
            if (!directDep.scope.equals("compile") && !directDep.scope.equals("runtime")) continue;
            Set<ArtifactSpec> transientDeps = buckets.get(directDep);
            if (transientDeps.isEmpty()) {
                declaredDependencies.add((Object)directDep);
                continue;
            }
            for (ArtifactSpec transientDep : transientDeps) {
                declaredDependencies.add((Object)directDep, (Object)transientDep);
            }
        }
        tool.declaredDependencies(declaredDependencies);
        this.project.getResources().forEach(r -> tool.resourceDirectory(r.getDirectory()));
        Path uberjarResourcesDir = null;
        uberjarResourcesDir = this.uberjarResources == null ? Paths.get(this.project.getBasedir().toString(), new String[0]).resolve("src").resolve("main").resolve("uberjar") : Paths.get(this.uberjarResources, new String[0]);
        tool.uberjarResourcesDirectory(uberjarResourcesDir);
        this.additionalModules.stream().map(m -> new File(this.project.getBuild().getOutputDirectory(), (String)m)).filter(File::exists).map(File::getAbsolutePath).forEach(arg_0 -> ((BuildTool)tool).additionalModule(arg_0));
        try {
            String jarFinalName = finalName + (this.hollow ? "-hollow" : "") + "-swarm";
            if (this.finalName != null) {
                jarFinalName = this.finalName;
            }
            jarFinalName = jarFinalName + ".jar";
            File jar = tool.build(jarFinalName, Paths.get(this.projectBuildDir, new String[0]));
            DefaultArtifactHandler handler = new DefaultArtifactHandler("jar");
            DefaultArtifact swarmJarArtifact = new DefaultArtifact(primaryArtifact.getGroupId(), primaryArtifact.getArtifactId(), primaryArtifact.getBaseVersion(), primaryArtifact.getScope(), "jar", (this.hollow ? "hollow" : "") + "swarm", (ArtifactHandler)handler);
            swarmJarArtifact.setFile(jar);
            this.project.addAttachedArtifact((Artifact)swarmJarArtifact);
            if (this.project.getPackaging().equals("war")) {
                tool.repackageWar(primaryArtifactFile);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Unable to create -swarm.jar", (Throwable)e);
        }
    }
}

