/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.netflix.ribbon.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceActivatorContext;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.swarm.netflix.ribbon.runtime.ApplicationAdvertiser;
import org.wildfly.swarm.netflix.ribbon.runtime.ClusterManager;

public class ApplicationAdvertiserActivator
implements ServiceActivator {
    public void activate(ServiceActivatorContext context) throws ServiceRegistryException {
        ServiceTarget target = context.getServiceTarget();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/netflix-ribbon-application.conf");
        if (in == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String appName = null;
            while ((appName = reader.readLine()) != null) {
                if ((appName = appName.trim()).isEmpty()) continue;
                ApplicationAdvertiser advertiser = new ApplicationAdvertiser(appName);
                target.addService(ServiceName.of((String[])new String[]{"netflix", "ribbon", "advertise", appName}), (Service)advertiser).addDependency(ClusterManager.SERVICE_NAME, ClusterManager.class, advertiser.getClusterManagerInjector()).install();
            }
        }
        catch (IOException e) {
            throw new ServiceRegistryException((Throwable)e);
        }
    }
}

