/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.shrinkwrap;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.container.DefaultDeployment;
import org.wildfly.swarm.container.Deployment;

public class ShrinkWrapDeployment<T extends Archive>
implements Deployment {
    protected final T archive;

    public ShrinkWrapDeployment(String name, Class<T> archiveType) {
        this.archive = (Archive)ShrinkWrap.create(archiveType, (String)name);
    }

    public T getArchive() {
        return this.archive;
    }

    public String getName() {
        return this.archive.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualFile getContent() throws IOException {
        VirtualFile mountPoint = VFS.getRootVirtualFile().getChild(this.archive.getName());
        try (InputStream in = ((ZipExporter)this.archive.as(ZipExporter.class)).exportAsInputStream();){
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            TempFileProvider tempFileProvider = TempFileProvider.create((String)"wildfly-swarm", (ScheduledExecutorService)executor);
            VFS.mountZip((InputStream)in, (String)this.archive.getName(), (VirtualFile)mountPoint, (TempFileProvider)tempFileProvider);
            DefaultDeployment.ensureJBossWebXml((VirtualFile)mountPoint);
            VirtualFile virtualFile = mountPoint;
            return virtualFile;
        }
    }
}

