/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.asset.ZipFileEntryAsset;
import org.wildfly.swarm.tools.ArchiveAsset;
import org.wildfly.swarm.tools.ArtifactAsset;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildException;
import org.wildfly.swarm.tools.ProjectAsset;

public class BuildTool {
    private final JavaArchive archive;
    private String mainClass;
    private String contextPath = "/";
    private boolean bundleDependencies = true;
    private final Set<ArtifactSpec> dependencies = new HashSet<ArtifactSpec>();
    private final Set<ArtifactSpec> moduleDependencies = new HashSet<ArtifactSpec>();
    private final Set<String> resourceDirectories = new HashSet<String>();
    private ProjectAsset projectAsset;
    private ArtifactResolvingHelper resolver;
    private Properties properties = new Properties();
    private Set<ArtifactSpec> bootstrappedArtifacts = new HashSet<ArtifactSpec>();
    private Set<String> bootstrappedModules = new HashSet<String>();
    private Map<String, String> providedMappings = new HashMap<String, String>();
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile("<artifact name=\"([^\"]+)\".*");

    public BuildTool() {
        this.archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
    }

    public BuildTool mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public BuildTool contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public BuildTool properties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public BuildTool bundleDependencies(boolean bundleDependencies) {
        this.bundleDependencies = bundleDependencies;
        return this;
    }

    public BuildTool projectArtifact(String groupId, String artifactId, String version, String packaging, File file) {
        this.projectAsset = new ArtifactAsset(new ArtifactSpec(null, groupId, artifactId, version, packaging, null, file));
        return this;
    }

    public BuildTool projectArchive(Archive archive) {
        this.projectAsset = new ArchiveAsset(archive);
        return this;
    }

    public BuildTool dependency(String scope, String groupId, String artifactId, String version, String packaging, String classifier, File file) {
        this.dependencies.add(new ArtifactSpec(scope, groupId, artifactId, version, packaging, classifier, file));
        return this;
    }

    public Set<ArtifactSpec> dependencies() {
        return this.dependencies;
    }

    public Set<ArtifactSpec> moduleDependencies() {
        return this.moduleDependencies;
    }

    public BuildTool artifactResolvingHelper(ArtifactResolvingHelper resolver) {
        this.resolver = resolver;
        return this;
    }

    public BuildTool resourceDirectory(String dir) {
        this.resourceDirectories.add(dir);
        return this;
    }

    public File build(String baseName, Path dir) throws Exception {
        this.build();
        return this.createJar(baseName, dir);
    }

    public Archive build() throws Exception {
        this.addWildflySwarmBootstrapJar();
        this.setupBootstrap();
        this.setupApplication();
        this.createManifest();
        this.createWildflySwarmProperties();
        this.createDependenciesTxt();
        this.collectDependencies();
        return this.archive;
    }

    private void addWildflySwarmBootstrapJar() throws BuildException, IOException {
        ArtifactSpec artifact = this.findArtifact("org.wildfly.swarm", "wildfly-swarm-bootstrap", null, "jar", null);
        if (!this.bootstrapJarShadesJBossModules(artifact.file)) {
            ArtifactSpec jbossModules = this.findArtifact("org.jboss.modules", "jboss-modules", null, "jar", null);
            this.expandArtifact(jbossModules.file);
        }
        this.expandArtifact(artifact.file);
    }

    private void setupBootstrap() throws Exception {
        for (ArtifactSpec each : this.dependencies) {
            JarFile jar = new JarFile(each.file);
            Throwable throwable = null;
            try {
                ZipEntry entry = jar.getEntry("wildfly-swarm-bootstrap.conf");
                if (entry == null) continue;
                this.bootstrappedArtifacts.add(each);
                InputStream in = jar.getInputStream(entry);
                Throwable throwable2 = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        this.bootstrappedModules.add(line);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (in == null) continue;
                    if (throwable2 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (jar == null) continue;
                if (throwable != null) {
                    try {
                        jar.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                jar.close();
            }
        }
        StringBuilder bootstrapTxt = new StringBuilder();
        for (ArtifactSpec each : this.bootstrappedArtifacts) {
            bootstrapTxt.append(each.mscCoordinates()).append("\n");
            this.gatherDependency(each);
        }
        this.archive.add((Asset)new StringAsset(bootstrapTxt.toString()), "META-INF/wildfly-swarm-bootstrap.conf");
    }

    private void setupApplication() throws Exception {
        HashSet<ArtifactSpec> applicationArtifacts = new HashSet<ArtifactSpec>();
        for (ArtifactSpec each : this.dependencies) {
            if (this.bootstrappedArtifacts.contains(each)) continue;
            applicationArtifacts.add(each);
        }
        this.archive.add((NamedAsset)this.projectAsset);
        StringBuilder bootstrapTxt = new StringBuilder();
        for (String string : this.bootstrappedModules) {
            bootstrapTxt.append("module:").append(string).append("\n");
        }
        for (ArtifactSpec artifactSpec : applicationArtifacts) {
            String mapped = this.providedMappings.get(artifactSpec.groupId + ":" + artifactSpec.artifactId);
            if (mapped != null) {
                bootstrapTxt.append("module:").append(mapped).append("\n");
                continue;
            }
            this.gatherDependency(artifactSpec);
            if (artifactSpec.classifier == null || artifactSpec.classifier.equals("")) {
                bootstrapTxt.append("gav:").append(artifactSpec.groupId + ":" + artifactSpec.artifactId + ":" + artifactSpec.version).append("\n");
                continue;
            }
            bootstrapTxt.append("gav:").append(artifactSpec.groupId + ":" + artifactSpec.artifactId + ":" + artifactSpec.version + ":" + artifactSpec.classifier).append("\n");
        }
        bootstrapTxt.append("path:").append(this.projectAsset.getName()).append("\n");
        this.archive.add((Asset)new StringAsset(bootstrapTxt.toString()), "META-INF/wildfly-swarm-application.conf");
    }

    public boolean includeAsBootstrapJar(ArtifactSpec dependency) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasNonBootstrapMarker(ArtifactSpec spec) {
        if (spec.file == null) return false;
        try (JarFile jar = new JarFile(spec.file);){
            ZipEntry entry = jar.getEntry("META-INF/wildfly-swarm-non-bootstrap.txt");
            boolean bl = entry != null;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected void gatherDependency(ArtifactSpec artifact) throws Exception {
        ArtifactSpec originalArtifact = artifact;
        if (artifact.file == null) {
            artifact = this.resolver.resolve(artifact);
        }
        if (artifact == null) {
            throw new BuildException("Unable to resolve artifact: " + originalArtifact);
        }
        StringBuilder artifactPath = new StringBuilder("m2repo");
        String[] groupIdParts = artifact.groupId.split("\\.");
        for (int i = 0; i < groupIdParts.length; ++i) {
            artifactPath.append('/').append(groupIdParts[i]);
        }
        artifactPath.append('/').append(artifact.artifactId);
        artifactPath.append('/').append(artifact.version);
        artifactPath.append('/').append(artifact.file.getName());
        this.archive.add((Asset)new FileAsset(artifact.file), artifactPath.toString());
    }

    private void createManifest() throws IOException {
        Manifest manifest = new Manifest();
        Attributes attrs = manifest.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attrs.put(Attributes.Name.MAIN_CLASS, "org.wildfly.swarm.bootstrap.Main");
        if (this.mainClass != null && !this.mainClass.equals("")) {
            attrs.put(new Attributes.Name("Wildfly-Swarm-Main-Class"), this.mainClass);
        }
        ByteArrayOutputStream manifestBytes = new ByteArrayOutputStream();
        manifest.write(manifestBytes);
        this.archive.addAsManifestResource((Asset)new ByteArrayAsset(manifestBytes.toByteArray()), "MANIFEST.MF");
    }

    private void createWildflySwarmProperties() throws IOException {
        Properties props = new Properties();
        Enumeration<?> propNames = this.properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String eachName = (String)propNames.nextElement();
            String eachValue = this.properties.get(eachName).toString();
            props.put(eachName, eachValue);
        }
        props.setProperty("wildfly.swarm.app.artifact", this.projectAsset.getSimpleName());
        props.setProperty("wildfly.swarm.context.path", this.contextPath);
        ByteArrayOutputStream propsBytes = new ByteArrayOutputStream();
        props.store(propsBytes, "Generated by WildFly Swarm");
        this.archive.addAsManifestResource((Asset)new ByteArrayAsset(propsBytes.toByteArray()), "wildfly-swarm.properties");
    }

    private void createDependenciesTxt() throws IOException {
        HashSet<String> provided = new HashSet<String>();
        for (ArtifactSpec artifactSpec : this.dependencies) {
            if (!artifactSpec.packaging.equals("jar")) continue;
            JarFile jar = new JarFile(artifactSpec.file);
            Throwable throwable = null;
            try {
                ZipEntry entry = jar.getEntry("provided-dependencies.txt");
                if (entry == null) continue;
                provided.add(artifactSpec.groupId + ":" + artifactSpec.artifactId);
                InputStream in = jar.getInputStream(entry);
                Throwable throwable2 = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        String[] parts = line.split("\\|");
                        if (parts.length > 1) {
                            this.providedMappings.put(parts[0], parts[1]);
                        }
                        provided.add(parts[0].trim());
                    }
                }
                catch (Throwable reader) {
                    throwable2 = reader;
                    throw reader;
                }
                finally {
                    if (in == null) continue;
                    if (throwable2 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable reader) {
                            throwable2.addSuppressed(reader);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (jar == null) continue;
                if (throwable != null) {
                    try {
                        jar.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    continue;
                }
                jar.close();
            }
        }
        for (String string : this.resourceDirectories) {
            Path providedDependencies = Paths.get(string, "provided-dependencies.txt");
            if (!Files.exists(providedDependencies, new LinkOption[0])) continue;
            FileInputStream in = new FileInputStream(providedDependencies.toFile());
            Throwable throwable = null;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    String[] parts = line.split("\\|");
                    if (parts.length > 1) {
                        this.providedMappings.put(parts[0], parts[1]);
                    }
                    provided.add(parts[0].trim());
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
        StringBuilder depsTxt = new StringBuilder();
        for (ArtifactSpec each : this.dependencies) {
            if (provided.contains(each.groupId + ":" + each.artifactId) || !each.scope.equals("compile") || !each.packaging.equals("jar")) continue;
            each.shouldGather = true;
            depsTxt.append(each.groupId).append(':').append(each.artifactId).append(':').append(each.version).append("\n");
        }
        this.archive.addAsManifestResource((Asset)new StringAsset(depsTxt.toString()), "wildfly-swarm-dependencies.txt");
    }

    protected void collectDependencies() throws Exception {
        if (!this.bundleDependencies) {
            return;
        }
        this.analyzeModuleDependencies();
        this.gatherDependencies();
    }

    protected void analyzeModuleDependencies() throws IOException {
        for (ArtifactSpec each : this.bootstrappedArtifacts) {
            this.analyzeModuleDependencies(each);
        }
    }

    protected void analyzeModuleDependencies(ArtifactSpec artifact) throws IOException {
        if (!artifact.packaging.equals("jar")) {
            return;
        }
        JarFile jar = new JarFile(artifact.file);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry each = entries.nextElement();
            String name = each.getName();
            if (!name.startsWith("modules/") || !name.endsWith("module.xml")) continue;
            InputStream in = jar.getInputStream(each);
            Throwable throwable = null;
            try {
                this.analyzeModuleDependencies(in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    protected void analyzeModuleDependencies(InputStream moduleXml) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(moduleXml));
        String line = null;
        while ((line = reader.readLine()) != null) {
            Matcher matcher = ARTIFACT_PATTERN.matcher(line.trim());
            if (!matcher.matches()) continue;
            String[] parts = matcher.group(1).split(":");
            String groupId = parts[0];
            String artifactId = parts[1];
            String version = parts[2];
            String packaging = "jar";
            String classifier = null;
            if (parts.length > 3) {
                classifier = parts[3];
            }
            ArtifactSpec dep = new ArtifactSpec("compile", groupId, artifactId, version, packaging, classifier, null);
            dep.shouldGather = true;
            this.moduleDependencies.add(dep);
        }
    }

    protected void gatherDependencies() throws Exception {
        this.dependencies.addAll(this.moduleDependencies);
        for (ArtifactSpec each : this.dependencies) {
            if (!each.shouldGather) continue;
            this.gatherDependency(each);
        }
    }

    private File createJar(String baseName, Path dir) throws IOException {
        File out = new File(dir.toFile(), baseName + "-swarm.jar");
        ZipExporter exporter = (ZipExporter)this.archive.as(ZipExporter.class);
        exporter.exportTo(out, true);
        return out;
    }

    public ArtifactSpec findArtifact(String groupId, String artifactId, String version, String packaging, String classifier) {
        for (ArtifactSpec each : this.dependencies) {
            if (groupId != null && !groupId.equals(each.groupId) || artifactId != null && !artifactId.equals(each.artifactId) || version != null && !version.equals(each.version) || packaging != null && !packaging.equals(each.packaging) || classifier != null && !classifier.equals(each.classifier)) continue;
            return each;
        }
        return null;
    }

    public boolean bootstrapJarShadesJBossModules(File artifactFile) throws IOException {
        JarFile jarFile = new JarFile(artifactFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        boolean jbossModulesFound = false;
        while (entries.hasMoreElements()) {
            JarEntry each = entries.nextElement();
            if (!each.getName().startsWith("org/jboss/modules/ModuleLoader")) continue;
            jbossModulesFound = true;
        }
        return jbossModulesFound;
    }

    public void expandArtifact(File artifactFile) throws IOException {
        JarFile jarFile = new JarFile(artifactFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry each = entries.nextElement();
            if (each.getName().startsWith("META-INF") || each.isDirectory()) continue;
            this.archive.add((Asset)new ZipFileEntryAsset((ZipFile)jarFile, (ZipEntry)each), each.getName());
        }
    }
}

