/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class PackageDetector {
    public static Set<String> detectPackages(ZipFile file) throws IOException {
        PackageCollector visitor = new PackageCollector();
        return PackageDetector.detectPackages(file, visitor);
    }

    protected static Set<String> detectPackages(ZipFile file, PackageCollector visitor) throws IOException {
        Enumeration<? extends ZipEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.endsWith(".jar")) {
                File jarFile = File.createTempFile("swarmPackageDetector", ".jar");
                jarFile.deleteOnExit();
                try (InputStream in = file.getInputStream(entry);
                     FileOutputStream out = new FileOutputStream(jarFile);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                PackageDetector.detectPackages(new ZipFile(jarFile), visitor);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            InputStream in = file.getInputStream(entry);
            Throwable throwable = null;
            try {
                new ClassReader(in).accept((ClassVisitor)visitor, 0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
        return visitor.packages();
    }

    static class PackageCollector
    extends ClassVisitor {
        private final Set<String> packages = new HashSet<String>();
        private final AnnotationVisitor ANNOTATION_VISITOR = new AnnotationVisitor(327680){

            public void visit(String __, Object value) {
                if (value instanceof Type) {
                    this.addType((Type)value);
                }
            }

            public void visitEnum(String __, String desc, String ___) {
                this.addType(desc);
            }

            public AnnotationVisitor visitAnnotation(String __, String desc) {
                this.addType(desc);
                return this;
            }

            public AnnotationVisitor visitArray(String __) {
                return this;
            }
        };
        private final SignatureVisitor SIGNATURE_VISITOR = new SignatureVisitor(327680){
            private String outerName;

            public void visitClassType(String name) {
                this.outerName = name;
                this.addInternalType(name);
            }

            public void visitInnerClassType(String name) {
                this.outerName = this.outerName + "$" + name;
                this.addInternalType(this.outerName);
            }
        };

        public Set<String> packages() {
            return this.packages;
        }

        public PackageCollector() {
            super(327680);
        }

        public void visit(int __, int ___, String name, String signature, String superName, String[] interfaces) {
            this.addPackage(name);
            if (signature == null) {
                if (superName != null) {
                    this.addInternalType(superName);
                }
                this.addInternalTypes(interfaces);
            } else {
                this.addSignature(signature);
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean __) {
            this.addType(desc);
            return new AnnotationVisitor(327680){

                public void visit(String __, Object value) {
                    if (value instanceof Type) {
                        this.addType((Type)value);
                    }
                }

                public void visitEnum(String __, String desc, String ___) {
                    this.addType(desc);
                }

                public AnnotationVisitor visitAnnotation(String __, String desc) {
                    this.addType(desc);
                    return this;
                }

                public AnnotationVisitor visitArray(String __) {
                    return this;
                }
            };
        }

        public AnnotationVisitor visitTypeAnnotation(int __, TypePath ___, String desc, boolean ____) {
            this.addType(desc);
            return this.ANNOTATION_VISITOR;
        }

        public FieldVisitor visitField(int __, String ___, String desc, String signature, Object value) {
            if (value instanceof Type) {
                this.addType((Type)value);
            }
            if (signature != null) {
                this.addTypeSignature(signature);
            } else {
                this.addType(desc);
            }
            return new FieldVisitor(327680){

                public AnnotationVisitor visitAnnotation(String desc, boolean __) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                public AnnotationVisitor visitTypeAnnotation(int __, TypePath ___, String desc, boolean ____) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }
            };
        }

        public MethodVisitor visitMethod(int __, String ___, String desc, String signature, String[] exceptions) {
            if (signature != null) {
                this.addSignature(signature);
            } else {
                this.addMethodTypes(desc);
            }
            this.addInternalTypes(exceptions);
            return new MethodVisitor(327680){

                public AnnotationVisitor visitAnnotationDefault() {
                    return ANNOTATION_VISITOR;
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean __) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                public AnnotationVisitor visitTypeAnnotation(int __, TypePath ___, String desc, boolean ____) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                public AnnotationVisitor visitParameterAnnotation(int __, String desc, boolean ___) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                public void visitTypeInsn(int __, String type) {
                    this.addType(Type.getObjectType((String)type));
                }

                public void visitFieldInsn(int __, String owner, String ___, String desc) {
                    this.addInternalType(owner);
                    this.addType(desc);
                }

                public void visitMethodInsn(int __, String owner, String ___, String desc, boolean ____) {
                    this.addInternalType(owner);
                    this.addMethodTypes(desc);
                }

                public void visitInvokeDynamicInsn(String __, String desc, Handle bsm, Object ... bsmArgs) {
                    this.addMethodTypes(desc);
                    this.addConstant(bsm);
                    for (Object each : bsmArgs) {
                        this.addConstant(each);
                    }
                }

                public void visitLdcInsn(Object cst) {
                    this.addConstant(cst);
                }

                public void visitMultiANewArrayInsn(String desc, int __) {
                    this.addType(desc);
                }

                public AnnotationVisitor visitInsnAnnotation(int __, TypePath ___, String desc, boolean ____) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                public void visitLocalVariable(String __, String ___, String signature, Label ____, Label _____, int ______) {
                    this.addTypeSignature(signature);
                }

                public AnnotationVisitor visitLocalVariableAnnotation(int __, TypePath ___, Label[] ____, Label[] _____, int[] ______, String desc, boolean _______) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                public void visitTryCatchBlock(Label __, Label ____, Label _____, String type) {
                    if (type != null) {
                        this.addInternalType(type);
                    }
                }

                public AnnotationVisitor visitTryCatchAnnotation(int __, TypePath ___, String desc, boolean ____) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }
            };
        }

        private String addPackage(String name) {
            if (name != null) {
                int pos = name.lastIndexOf(47);
                if (pos > -1) {
                    name = name.substring(0, pos);
                }
                this.packages.add(name.replace('/', '.'));
            }
            return name;
        }

        private void addType(Type type) {
            switch (type.getSort()) {
                case 9: {
                    this.addType(type.getElementType());
                    break;
                }
                case 10: {
                    this.addPackage(type.getInternalName());
                    break;
                }
                case 11: {
                    this.addMethodTypes(type.getDescriptor());
                }
            }
        }

        private void addType(String desc) {
            this.addType(Type.getType((String)desc));
        }

        private void addInternalType(String name) {
            this.addType(Type.getObjectType((String)name));
        }

        private void addInternalTypes(String[] names) {
            if (names != null) {
                for (String each : names) {
                    if (each == null) continue;
                    this.addInternalType(each);
                }
            }
        }

        private void addMethodTypes(String desc) {
            this.addType(Type.getReturnType((String)desc));
            for (Type each : Type.getArgumentTypes((String)desc)) {
                this.addType(each);
            }
        }

        private void addSignature(String signature) {
            if (signature != null) {
                new SignatureReader(signature).accept(this.SIGNATURE_VISITOR);
            }
        }

        void addTypeSignature(String signature) {
            if (signature != null) {
                new SignatureReader(signature).acceptType(this.SIGNATURE_VISITOR);
            }
        }

        void addConstant(Object constant) {
            if (constant instanceof Type) {
                this.addType((Type)constant);
            } else if (constant instanceof Handle) {
                Handle handle = (Handle)constant;
                this.addInternalType(handle.getOwner());
                this.addMethodTypes(handle.getDesc());
            }
        }
    }
}

