/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.UUID;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.importer.zip.ZipImporterImpl;
import org.wildfly.swarm.container.Container;
import org.wildfly.swarm.container.DefaultDeploymentFactory;
import org.wildfly.swarm.container.DependenciesContainer;
import org.wildfly.swarm.undertow.WARArchive;

public class DefaultWarDeploymentFactory
implements DefaultDeploymentFactory {
    public int getPriority() {
        return 0;
    }

    public String getType() {
        return "war";
    }

    public Archive create(Container container) throws Exception {
        WARArchive archive = (WARArchive)ShrinkWrap.create(WARArchive.class, (String)this.determineName());
        this.setup(archive);
        archive.addModule("org.wildfly.swarm.undertow", "runtime");
        archive.addAsServiceProvider("io.undertow.server.handlers.builder.HandlerBuilder", new String[]{"org.wildfly.swarm.undertow.runtime.StaticHandlerBuilder"});
        return archive;
    }

    protected String determineName() {
        String prop = System.getProperty("wildfly.swarm.app.path");
        if (prop != null) {
            File file = new File(prop);
            String name = file.getName();
            if (name.endsWith(".war")) {
                return name;
            }
            return name + ".war";
        }
        prop = System.getProperty("wildfly.swarm.app.artifact");
        if (prop != null) {
            return prop;
        }
        return UUID.randomUUID().toString() + ".war";
    }

    protected void setup(DependenciesContainer<?> archive) throws Exception {
        boolean result = this.setupUsingAppPath(archive) || this.setupUsingAppArtifact(archive) || this.setupUsingMaven(archive);
    }

    protected boolean setupUsingAppPath(final DependenciesContainer<?> archive) throws IOException {
        String appPath = System.getProperty("wildfly.swarm.app.path");
        if (appPath != null) {
            final Path path = Paths.get(System.getProperty("wildfly.swarm.app.path"), new String[0]);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path simple = path.relativize(file);
                        archive.add((Asset)new FileAsset(file.toFile()), DefaultWarDeploymentFactory.this.convertSeparators(simple));
                        return super.visitFile(file, attrs);
                    }
                });
            } else {
                ZipImporterImpl importer = new ZipImporterImpl(archive);
                importer.importFrom(new File(System.getProperty("wildfly.swarm.app.path")));
            }
            return true;
        }
        return false;
    }

    protected boolean setupUsingAppArtifact(DependenciesContainer<?> archive) throws IOException {
        String appArtifact = System.getProperty("wildfly.swarm.app.artifact");
        if (appArtifact != null) {
            try (InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("_bootstrap/" + appArtifact);){
                ZipImporterImpl importer = new ZipImporterImpl(archive);
                importer.importFrom(in);
            }
            return true;
        }
        return false;
    }

    protected boolean setupUsingMaven(final DependenciesContainer<?> archive) throws Exception {
        Path webapp;
        Path pwd = Paths.get(System.getProperty("user.dir"), new String[0]);
        final Path classes = pwd.resolve("target").resolve("classes");
        boolean success = false;
        if (Files.exists(classes, new LinkOption[0])) {
            success = true;
            Files.walkFileTree(classes, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = classes.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), "WEB-INF/classes/" + DefaultWarDeploymentFactory.this.convertSeparators(simple));
                    return super.visitFile(file, attrs);
                }
            });
        }
        if (Files.exists(webapp = pwd.resolve("src").resolve("main").resolve("webapp"), new LinkOption[0])) {
            success = true;
            Files.walkFileTree(webapp, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path simple = webapp.relativize(file);
                    archive.add((Asset)new FileAsset(file.toFile()), DefaultWarDeploymentFactory.this.convertSeparators(simple));
                    return super.visitFile(file, attrs);
                }
            });
        }
        archive.addAllDependencies();
        return success;
    }

    protected String convertSeparators(Path path) {
        String convertedPath = path.toString();
        if (convertedPath.contains(File.separator)) {
            convertedPath = convertedPath.replace(File.separator, "/");
        }
        return convertedPath;
    }
}

