/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.undertow;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.wildfly.swarm.undertow.JBossWebAsset;

public interface JBossWebContainer<T extends Archive<T>>
extends Archive<T> {
    public static final String JBOSS_WEB_PATH = "WEB-INF/jboss-web.xml";

    default public T setDefaultContextRoot() {
        JBossWebAsset asset = this.findJbossWebAsset();
        if (asset.isRootSet()) {
            return (T)this;
        }
        String contextRoot = System.getProperty("wildfly.swarm.context.path");
        if (contextRoot == null) {
            contextRoot = "/";
        }
        this.setContextRoot(contextRoot);
        return (T)this;
    }

    default public T setContextRoot(String contextRoot) {
        this.findJbossWebAsset().setContextRoot(contextRoot);
        return (T)this;
    }

    default public JBossWebAsset findJbossWebAsset() {
        Asset asset;
        Node jbossWeb = this.get(JBOSS_WEB_PATH);
        if (jbossWeb == null) {
            asset = new JBossWebAsset();
            this.add(asset, JBOSS_WEB_PATH);
        } else {
            asset = jbossWeb.getAsset();
            if (!(asset instanceof JBossWebAsset)) {
                asset = new JBossWebAsset(asset.openStream());
                this.add(asset, JBOSS_WEB_PATH);
            }
        }
        return (JBossWebAsset)asset;
    }
}

