/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.url.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.url.http.ElytronCredentialsProvider;

class HttpClientURLConnection
extends HttpsURLConnection {
    private final HttpHost proxy;
    private CloseableHttpClient client;
    private CloseableHttpResponse response;
    private ByteArrayOutputStream outputStream;
    private SSLSession sslSession;

    HttpClientURLConnection(URL url, Proxy proxy) throws IOException {
        super(url);
        this.proxy = this.convertProxy(proxy);
    }

    private HttpHost convertProxy(Proxy proxy) throws UnknownHostException {
        if (proxy == null || proxy.type() == Proxy.Type.DIRECT) {
            return null;
        }
        if (proxy.type() == Proxy.Type.HTTP && proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            if (address.getAddress() == null) {
                throw new UnknownHostException("Unable resolve proxy address");
            }
            return new HttpHost(address.getAddress(), address.getPort(), "http");
        }
        throw new UnsupportedOperationException("Unsupported type of proxy.");
    }

    private HttpUriRequest getRequest(URI uri) {
        switch (this.getRequestMethod()) {
            case "GET": {
                return new HttpGet(uri);
            }
            case "POST": {
                return new HttpPost(uri);
            }
            case "HEAD": {
                return new HttpHead(uri);
            }
            case "OPTIONS": {
                return new HttpOptions(uri);
            }
            case "PUT": {
                return new HttpPut(uri);
            }
            case "DELETE": {
                return new HttpDelete(uri);
            }
            case "TRACE": {
                return new HttpTrace(uri);
            }
        }
        throw new IllegalStateException("Unsupported HTTP request method");
    }

    private void doRequest() throws IOException {
        URI uri;
        try {
            uri = this.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to construct URI from URL", e);
        }
        HttpUriRequest request = this.getRequest(uri);
        if (this.getIfModifiedSince() != 0L) {
            request.setHeader("If-Modified-Since", DateUtils.formatDate((Date)new Date(this.getIfModifiedSince())));
        }
        for (Map.Entry<String, List<String>> prop : this.getRequestProperties().entrySet()) {
            for (String value : prop.getValue()) {
                request.addHeader(prop.getKey(), value);
            }
        }
        if (this.outputStream != null) {
            if (request instanceof HttpEntityEnclosingRequestBase) {
                ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)new ByteArrayEntity(this.outputStream.toByteArray()));
            } else {
                throw new IllegalStateException("Used HTTP request method does not support OutputStream");
            }
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.getConnectTimeout()).setSocketTimeout(this.getReadTimeout()).setRedirectsEnabled(this.getInstanceFollowRedirects()).setProxy(this.proxy).build();
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)ElytronCredentialsProvider.INSTANCE).setDefaultRequestConfig(config);
        if (uri.getScheme().equalsIgnoreCase("https")) {
            SSLSocketFactory socketFactory = this.getSSLSocketFactory();
            if (socketFactory != HttpClientURLConnection.getDefaultSSLSocketFactory()) {
                HostnameVerifier hostnameVerifier = this.getHostnameVerifier();
                if (hostnameVerifier == HttpClientURLConnection.getDefaultHostnameVerifier()) {
                    hostnameVerifier = null;
                }
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(socketFactory, hostnameVerifier));
            } else {
                try {
                    SecurityFactory sslContextFactory = ElytronCredentialsProvider.client.getSSLContextFactory(uri, AuthenticationContext.captureCurrent(), null, null);
                    builder.setSSLContext((SSLContext)sslContextFactory.create());
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
            this.client = builder.build();
            BasicHttpContext context = new BasicHttpContext();
            this.response = this.client.execute(request, (HttpContext)context);
            ManagedHttpClientConnection routedConnection = (ManagedHttpClientConnection)context.getAttribute("http.connection");
            this.sslSession = routedConnection.getSSLSession();
        } else {
            this.client = builder.build();
            this.response = this.client.execute(request);
        }
    }

    private void ensureResponse() {
        if (this.response == null) {
            try {
                this.doRequest();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void connect() throws IOException {
        this.doRequest();
    }

    @Override
    public void disconnect() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean usingProxy() {
        return this.proxy != null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream();
        }
        return this.outputStream;
    }

    @Override
    public void setFixedLengthStreamingMode(int contentLength) {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream(contentLength);
        }
    }

    @Override
    public void setFixedLengthStreamingMode(long contentLength) {
        if (contentLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too long content length");
        }
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream((int)contentLength);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        int responseCode;
        if (this.response == null) {
            this.doRequest();
        }
        if ((responseCode = this.response.getStatusLine().getStatusCode()) >= 400) {
            if (responseCode == 404 || responseCode == 410) {
                throw new FileNotFoundException(this.url.toString());
            }
            throw new IOException("Server returned HTTP response code: " + responseCode + " for URL: " + this.getURL().toString());
        }
        if (responseCode == 304) {
            return new ByteArrayInputStream(new byte[0]);
        }
        HttpEntity entity = this.response.getEntity();
        if (entity == null) {
            throw new IOException("Used HTTP request method does not provide InputStream");
        }
        return entity.getContent();
    }

    @Override
    public InputStream getErrorStream() {
        if (this.response == null || this.response.getStatusLine().getStatusCode() < 400) {
            return null;
        }
        HttpEntity entity = this.response.getEntity();
        if (entity != null) {
            try {
                return entity.getContent();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.response == null) {
            this.doRequest();
        }
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String getResponseMessage() throws IOException {
        if (this.response == null) {
            this.doRequest();
        }
        return this.response.getStatusLine().getReasonPhrase();
    }

    @Override
    public String getHeaderField(String name) {
        this.ensureResponse();
        Header header = this.response.getLastHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        this.ensureResponse();
        HashMap output = new HashMap();
        for (Header header : this.response.getAllHeaders()) {
            String name = header.getName();
            if (!output.containsKey(name)) {
                output.put(name, new ArrayList(1));
            }
            ((List)output.get(name)).add(header.getValue());
        }
        return Collections.unmodifiableMap(output);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        this.ensureResponse();
        Header[] headers = this.response.getAllHeaders();
        if (0 > n || n >= headers.length) {
            return null;
        }
        return headers[n].getName();
    }

    @Override
    public String getHeaderField(int n) {
        this.ensureResponse();
        Header[] headers = this.response.getAllHeaders();
        if (0 > n || n >= headers.length) {
            return null;
        }
        return headers[n].getValue();
    }

    @Override
    public String getCipherSuite() {
        if (this.response == null) {
            throw new IllegalStateException("connection not yet open");
        }
        if (this.sslSession == null) {
            throw new UnsupportedOperationException("not a SSL connection");
        }
        return this.sslSession.getCipherSuite();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        if (this.response == null) {
            throw new IllegalStateException("connection not yet open");
        }
        if (this.sslSession == null) {
            throw new UnsupportedOperationException("not a SSL connection");
        }
        return this.sslSession.getLocalCertificates();
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (this.response == null) {
            throw new IllegalStateException("connection not yet open");
        }
        if (this.sslSession == null) {
            throw new UnsupportedOperationException("not a SSL connection");
        }
        return this.sslSession.getPeerCertificates();
    }
}

