/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.injection.chat;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import java.time.Duration;
import java.util.List;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;

public class WildFlyOpenAiChatModelConfig
implements WildFlyChatModelConfig {
    private String key;
    private String baseUrl;
    private Double frequencyPenalty;
    private Boolean logRequests;
    private Boolean logResponses;
    private Integer maxToken;
    private String modelName;
    private String organizationId;
    private Double presencePenalty;
    private Integer seed;
    private Double temperature;
    private long connectTimeOut;
    private Double topP;
    private boolean isJson;
    private boolean streaming;
    private boolean observable;

    @Override
    public ChatLanguageModel createLanguageModel(List<ChatModelListener> listeners) {
        OpenAiChatModel.OpenAiChatModelBuilder builder = OpenAiChatModel.builder().apiKey(this.key).baseUrl(this.baseUrl).frequencyPenalty(this.frequencyPenalty).logRequests(this.logRequests).logResponses(this.logResponses).maxRetries(Integer.valueOf(5)).maxTokens(this.maxToken).modelName(this.modelName).organizationId(this.organizationId).presencePenalty(this.presencePenalty).seed(this.seed).temperature(this.temperature).timeout(Duration.ofMillis(this.connectTimeOut)).topP(this.topP);
        if (this.isJson) {
            builder.responseFormat("json_object");
        }
        if (this.observable) {
            builder.listeners(listeners);
        }
        return builder.build();
    }

    @Override
    public StreamingChatLanguageModel createStreamingLanguageModel(List<ChatModelListener> listeners) {
        OpenAiStreamingChatModel.OpenAiStreamingChatModelBuilder builder = OpenAiStreamingChatModel.builder().apiKey(this.key).baseUrl(this.baseUrl).frequencyPenalty(this.frequencyPenalty).logRequests(this.logRequests).logResponses(this.logResponses).maxTokens(this.maxToken).modelName(this.modelName).organizationId(this.organizationId).presencePenalty(this.presencePenalty).seed(this.seed).temperature(this.temperature).timeout(Duration.ofMillis(this.connectTimeOut)).topP(this.topP);
        if (this.isJson) {
            builder.responseFormat("json_object");
        }
        if (this.observable) {
            builder.listeners(listeners);
        }
        return builder.build();
    }

    public WildFlyOpenAiChatModelConfig apiKey(String key) {
        this.key = key;
        return this;
    }

    public WildFlyOpenAiChatModelConfig baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public WildFlyOpenAiChatModelConfig frequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
        return this;
    }

    public WildFlyOpenAiChatModelConfig logRequests(Boolean logRequests) {
        this.logRequests = logRequests;
        return this;
    }

    public WildFlyOpenAiChatModelConfig logResponses(Boolean logResponses) {
        this.logResponses = logResponses;
        return this;
    }

    public WildFlyOpenAiChatModelConfig maxTokens(Integer maxToken) {
        this.maxToken = maxToken;
        return this;
    }

    public WildFlyOpenAiChatModelConfig modelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    public WildFlyOpenAiChatModelConfig organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    public WildFlyOpenAiChatModelConfig presencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
        return this;
    }

    public WildFlyOpenAiChatModelConfig seed(Integer seed) {
        this.seed = seed;
        return this;
    }

    public WildFlyOpenAiChatModelConfig temperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public WildFlyOpenAiChatModelConfig timeout(long connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
        return this;
    }

    public WildFlyOpenAiChatModelConfig topP(Double topP) {
        this.topP = topP;
        return this;
    }

    public WildFlyOpenAiChatModelConfig setJson(boolean isJson) {
        this.isJson = isJson;
        return this;
    }

    public WildFlyOpenAiChatModelConfig setStreaming(boolean streaming) {
        this.streaming = streaming;
        return this;
    }

    public WildFlyOpenAiChatModelConfig setObservable(boolean observable) {
        this.observable = observable;
        return this;
    }

    @Override
    public boolean isStreaming() {
        return this.streaming;
    }
}

