/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.injection.retriever;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.input.PromptTemplate;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.rag.content.retriever.neo4j.Neo4jContentRetriever;
import dev.langchain4j.store.graph.neo4j.Neo4jGraph;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import java.lang.annotation.Annotation;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.GraphDatabase;
import org.wildfly.extension.ai.injection.retriever.WildFlyContentRetrieverConfig;

public class Neo4JContentRetrieverConfig
implements WildFlyContentRetrieverConfig {
    private String boltUrl;
    private String userName;
    private String password;
    private PromptTemplate promptTemplate;
    private String chatLanguageModelName;

    @Override
    public ContentRetriever createContentRetriever(Instance<Object> lookup) {
        Instance chatLanguageModelInstance = lookup.select(ChatLanguageModel.class, new Annotation[]{NamedLiteral.of((String)this.chatLanguageModelName)});
        Neo4jGraph graph = this.userName != null ? Neo4jGraph.builder().driver(GraphDatabase.driver((String)this.boltUrl, (AuthToken)AuthTokens.basic((String)this.userName, (String)this.password))).build() : Neo4jGraph.builder().driver(GraphDatabase.driver((String)this.boltUrl, (AuthToken)AuthTokens.none())).build();
        return Neo4jContentRetriever.builder().graph(graph).promptTemplate(this.promptTemplate).chatLanguageModel((ChatLanguageModel)chatLanguageModelInstance.get()).build();
    }

    public Neo4JContentRetrieverConfig boltUrl(String boltUrl) {
        this.boltUrl = boltUrl;
        return this;
    }

    public Neo4JContentRetrieverConfig userName(String userName) {
        this.userName = userName;
        return this;
    }

    public Neo4JContentRetrieverConfig password(String password) {
        this.password = password;
        return this;
    }

    public Neo4JContentRetrieverConfig promptTemplate(PromptTemplate promptTemplate) {
        this.promptTemplate = promptTemplate;
        return this;
    }

    public Neo4JContentRetrieverConfig chatLanguageModel(String chatLanguageModelName) {
        this.chatLanguageModelName = chatLanguageModelName;
        return this;
    }
}

