/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.injection.memory;

import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.memory.chat.MessageWindowChatMemory;
import dev.langchain4j.memory.chat.TokenWindowChatMemory;
import dev.langchain4j.model.TokenCountEstimator;
import dev.langchain4j.model.embedding.onnx.HuggingFaceTokenCountEstimator;
import jakarta.enterprise.inject.Instance;
import jakarta.servlet.http.HttpSession;
import java.lang.annotation.Annotation;
import org.wildfly.extension.ai.injection.AILogger;

public class WildFlyChatMemoryProviderConfig {
    private static HuggingFaceTokenCountEstimator estimator = null;
    private int size;
    private boolean useHttpSession;
    private ChatMemoryType type;

    public ChatMemoryProvider createChatMemory(Instance<Object> lookup) {
        if (this.shouldUseHttpSession(lookup)) {
            AILogger.ROOT_LOGGER.warn("We are using HTTP Session");
            HttpSession session = (HttpSession)lookup.select(HttpSession.class, new Annotation[0]).get();
            switch (this.type) {
                case TOKEN: {
                    return memoryId -> TokenWindowChatMemory.builder().id((Object)session.getId()).maxTokens(Integer.valueOf(this.size), this.estimator()).build();
                }
            }
            return memoryId -> MessageWindowChatMemory.builder().id((Object)session.getId()).maxMessages(Integer.valueOf(this.size)).build();
        }
        return memoryId -> MessageWindowChatMemory.builder().id(memoryId).maxMessages(Integer.valueOf(this.size)).build();
    }

    private TokenCountEstimator estimator() {
        if (estimator == null) {
            estimator = new HuggingFaceTokenCountEstimator();
        }
        return estimator;
    }

    private boolean shouldUseHttpSession(Instance<Object> lookup) {
        return this.useHttpSession && lookup.select(HttpSession.class, new Annotation[0]).isResolvable();
    }

    public WildFlyChatMemoryProviderConfig size(int size) {
        this.size = size;
        return this;
    }

    public WildFlyChatMemoryProviderConfig useHttpSession(boolean useHttpSession) {
        this.useHttpSession = useHttpSession;
        return this;
    }

    public WildFlyChatMemoryProviderConfig type(String type) {
        this.type = ChatMemoryType.valueOf(type);
        return this;
    }

    public static enum ChatMemoryType {
        MESSAGE,
        TOKEN;

    }
}

